/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.strava.StravaProfileDefinition;
import org.pac4j.scribe.builder.api.StravaApi20;

public class StravaClient
extends OAuth20Client {
    private String approvalPrompt = "auto";

    public StravaClient() {
    }

    public StravaClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void internalInit() {
        this.configuration.setApi((Object)new StravaApi20(this.approvalPrompt));
        this.configuration.setProfileDefinition(new StravaProfileDefinition());
        this.defaultLogoutActionBuilder((ctx, session, profile, targetUrl) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)"https://www.strava.com/session")));
        super.internalInit();
    }

    public String getApprovalPrompt() {
        return this.approvalPrompt;
    }

    public void setApprovalPrompt(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }
}

