/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.GitHubApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.github.GitHubProfileDefinition;

public class GitHubClient
extends OAuth20Client {
    public static final String DEFAULT_SCOPE = "user";

    public GitHubClient() {
        this.setScope(DEFAULT_SCOPE);
    }

    public GitHubClient(String key, String secret) {
        this.setScope(DEFAULT_SCOPE);
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        this.configuration.setApi((DefaultApi20)GitHubApi.instance());
        this.configuration.setProfileDefinition(new GitHubProfileDefinition());
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> Optional.of(RedirectionActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)"https://github.com/logout")));
        super.clientInit();
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }
}

