/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.credentials.authenticator.OAuth10Authenticator;
import org.pac4j.oauth.credentials.extractor.OAuth10CredentialsExtractor;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.creator.OAuth10ProfileCreator;
import org.pac4j.oauth.redirect.OAuth10RedirectActionBuilder;

public class OAuth10Client<U extends OAuth10Profile>
extends IndirectClient<OAuth10Credentials, U> {
    protected OAuth10Configuration configuration = new OAuth10Configuration();

    protected void clientInit(WebContext context) {
        this.defaultRedirectActionBuilder(new OAuth10RedirectActionBuilder(this.configuration));
        this.defaultCredentialsExtractor(new OAuth10CredentialsExtractor(this.configuration));
        this.defaultAuthenticator(new OAuth10Authenticator(this.configuration));
        this.defaultProfileCreator(new OAuth10ProfileCreator(this.configuration));
    }

    public OAuth10Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuth10Configuration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.configuration.setClient(this);
    }

    public String getKey() {
        return this.configuration.getKey();
    }

    public void setKey(String key) {
        this.configuration.setKey(key);
    }

    public String getSecret() {
        return this.configuration.getSecret();
    }

    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.getCallbackUrl(), "callbackUrlResolver", this.getCallbackUrlResolver(), "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectActionBuilder", this.getRedirectActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "configuration", this.configuration});
    }
}

