/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenExtractor;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Map;

public class CasOAuthWrapperApi20
extends DefaultApi20 {
    private final String casServerUrl;
    private final boolean springSecurityCompliant;
    private final boolean implicitFlow;

    public CasOAuthWrapperApi20(String casServerUrl, boolean springSecurityCompliant, boolean implicitFlow) {
        this.casServerUrl = casServerUrl;
        this.springSecurityCompliant = springSecurityCompliant;
        this.implicitFlow = implicitFlow;
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        if (this.springSecurityCompliant) {
            return OAuth2AccessTokenJsonExtractor.instance();
        }
        return OAuth2AccessTokenExtractor.instance();
    }

    public String getAccessTokenEndpoint() {
        return this.casServerUrl + "/accessToken?";
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        if (this.implicitFlow) {
            return String.format(this.casServerUrl + "/authorize?response_type=token&client_id=%s&redirect_uri=%s", config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
        }
        return String.format(this.casServerUrl + "/authorize?response_type=code&client_id=%s&redirect_uri=%s", config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    protected String getAuthorizationBaseUrl() {
        return this.casServerUrl + "/authorize";
    }

    public Verb getAccessTokenVerb() {
        if (this.springSecurityCompliant) {
            return Verb.PUT;
        }
        return Verb.POST;
    }
}

