/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.oauth;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.ProxyOAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

public class ExtendedOAuth20ServiceImpl
extends ProxyOAuth20ServiceImpl {
    public ExtendedOAuth20ServiceImpl(DefaultApi20 api, OAuthConfig config, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) {
        super(api, config, connectTimeout, readTimeout, proxyHost, proxyPort);
    }

    public Token getAccessToken(Token requestToken, Verifier verifier) {
        ProxyOAuthRequest request = new ProxyOAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
        request.addBodyParameter("client_id", this.config.getApiKey());
        request.addBodyParameter("client_secret", this.config.getApiSecret());
        request.addBodyParameter("code", verifier.getValue());
        request.addBodyParameter("redirect_uri", this.config.getCallback());
        if (this.config.hasScope()) {
            request.addBodyParameter("scope", this.config.getScope());
        }
        request.addBodyParameter("grant_type", "authorization_code");
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }
}

