/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.StateApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public final class ExtendedFacebookApi
extends StateApi20 {
    private static final String AUTHORIZE_URL_WITH_STATE = "https://www.facebook.com/dialog/oauth?client_id=%s&redirect_uri=%s&state=%s";
    private static final String SCOPED_AUTHORIZE_URL_WITH_STATE = "https://www.facebook.com/dialog/oauth?client_id=%s&redirect_uri=%s&state=%s&scope=%s";

    public String getAccessTokenEndpoint() {
        return "https://graph.facebook.com/oauth/access_token";
    }

    public String getAuthorizationUrl(OAuthConfig config, String state) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. Facebook does not support OOB");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL_WITH_STATE, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)state), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL_WITH_STATE, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)state));
    }
}

