/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.yahoo;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.pac4j.core.profile.AttributesDefinition;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.yahoo.YahooAddress;
import org.pac4j.oauth.profile.yahoo.YahooDisclosure;
import org.pac4j.oauth.profile.yahoo.YahooEmail;
import org.pac4j.oauth.profile.yahoo.YahooImage;
import org.pac4j.oauth.profile.yahoo.YahooInterest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooProfile
extends OAuth10Profile {
    private static final long serialVersionUID = 791758805376191144L;

    protected AttributesDefinition getAttributesDefinition() {
        return OAuthAttributesDefinitions.yahooDefinition;
    }

    public String getEmail() {
        List<YahooEmail> emails = this.getEmails();
        if (emails != null) {
            for (YahooEmail email : emails) {
                if (email == null || (email.getPrimary() == null || !email.getPrimary().booleanValue()) && emails.size() != 1) continue;
                return email.getHandle();
            }
        }
        return null;
    }

    public String getFirstName() {
        return (String)this.getAttribute("givenName");
    }

    public String getFamilyName() {
        return (String)this.getAttribute("familyName");
    }

    public String getDisplayName() {
        return this.getFirstName() + " " + this.getFamilyName();
    }

    public String getUsername() {
        return (String)this.getAttribute("nickname");
    }

    public Locale getLocale() {
        return (Locale)this.getAttribute("lang");
    }

    public String getPictureUrl() {
        YahooImage yahooImage = (YahooImage)this.getAttribute("image");
        if (yahooImage != null) {
            return yahooImage.getImageUrl();
        }
        return null;
    }

    public String getProfileUrl() {
        return (String)this.getAttribute("profileUrl");
    }

    public String getAboutMe() {
        return (String)this.getAttribute("aboutMe");
    }

    public List<YahooAddress> getAddresses() {
        return (List)this.getAttribute("addresses");
    }

    public Integer getBirthYear() {
        return (Integer)this.getAttribute("birthYear");
    }

    public Date getBirthdate() {
        return (Date)this.getAttribute("birthdate");
    }

    public Date getCreated() {
        return (Date)this.getAttribute("created");
    }

    public Integer getDisplayAge() {
        return (Integer)this.getAttribute("displayAge");
    }

    public List<YahooDisclosure> getDisclosures() {
        return (List)this.getAttribute("disclosures");
    }

    public List<YahooEmail> getEmails() {
        return (List)this.getAttribute("emails");
    }

    public YahooImage getImage() {
        return (YahooImage)this.getAttribute("image");
    }

    public List<YahooInterest> getInterests() {
        return (List)this.getAttribute("interests");
    }

    public Boolean getIsConnected() {
        return (Boolean)this.getAttribute("isConnected");
    }

    public Date getMemberSince() {
        return (Date)this.getAttribute("memberSince");
    }

    public String getTimeZone() {
        return (String)this.getAttribute("timeZone");
    }

    public Date getUpdated() {
        return (Date)this.getAttribute("updated");
    }

    public String getUri() {
        return (String)this.getAttribute("uri");
    }
}

