/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.profile.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonObjectConverter
implements AttributeConverter<JsonObject> {
    private static final Logger logger = LoggerFactory.getLogger(JsonObjectConverter.class);
    private final Class<? extends JsonObject> clazz;

    public JsonObjectConverter(Class<? extends JsonObject> clazz) {
        this.clazz = clazz;
    }

    public JsonObject convert(Object attribute) {
        if (attribute != null && (attribute instanceof String || attribute instanceof JsonNode)) {
            try {
                Constructor<? extends JsonObject> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                JsonObject jsonObject = constructor.newInstance(new Object[0]);
                jsonObject.buildFrom(attribute);
                return jsonObject;
            }
            catch (Exception e) {
                logger.error("Cannot build JsonObject : {}", (Object)e, this.clazz);
            }
        }
        return null;
    }
}

