/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.oauth.client.BaseOAuth10Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.yahoo.YahooProfile;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.builder.api.YahooApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth10aServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YahooClient
extends BaseOAuth10Client<YahooProfile> {
    public YahooClient() {
    }

    public YahooClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected YahooClient newClient() {
        return new YahooClient();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.service = new ProxyOAuth10aServiceImpl((DefaultApi10a)new YahooApi(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl() {
        return "http://social.yahooapis.com/v1/me/guid?format=xml";
    }

    @Override
    protected YahooProfile retrieveUserProfileFromToken(Token accessToken) {
        String body = this.sendRequestForData(accessToken, this.getProfileUrl());
        String guid = StringUtils.substringBetween((String)body, (String)"<value>", (String)"</value>");
        logger.debug("guid : {}", (Object)guid);
        if (StringUtils.isBlank((CharSequence)guid)) {
            String message = "Cannot find guid from body : " + body;
            logger.error(message);
            throw new HttpCommunicationException(message);
        }
        body = this.sendRequestForData(accessToken, "http://social.yahooapis.com/v1/user/" + guid + "/profile?format=json");
        YahooProfile profile = this.extractUserProfile(body);
        this.addAccessTokenToProfile(profile, accessToken);
        return profile;
    }

    @Override
    protected YahooProfile extractUserProfile(String body) {
        YahooProfile profile = new YahooProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null && (json = json.get("profile")) != null) {
            profile.setId(JsonHelper.get(json, "guid"));
            for (String attribute : OAuthAttributesDefinitions.yahooDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

