/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.wordpress.WordPressProfile;
import org.scribe.builder.api.WordPressApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.oauth.ExtendedOAuth20ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordPressClient
extends BaseOAuth20Client<WordPressProfile> {
    public WordPressClient() {
    }

    public WordPressClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected WordPressClient newClient() {
        return new WordPressClient();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.service = new ExtendedOAuth20ServiceImpl(new WordPressApi(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl() {
        return "https://public-api.wordpress.com/rest/v1/me/?pretty=1";
    }

    @Override
    protected WordPressProfile extractUserProfile(String body) {
        WordPressProfile profile = new WordPressProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "ID"));
            for (String attribute : OAuthAttributesDefinitions.wordPressDefinition.getPrincipalAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
            if ((json = json.get("meta")) != null) {
                String attribute = "links";
                profile.addAttribute("links", JsonHelper.get(json, "links"));
            }
        }
        return profile;
    }

    @Override
    protected boolean requiresStateParameter() {
        return false;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

