/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.windowslive.WindowsLiveProfile;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.builder.api.LiveApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.oauth.ProxyOAuth20ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsLiveClient
extends BaseOAuth20Client<WindowsLiveProfile> {
    public WindowsLiveClient() {
    }

    public WindowsLiveClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected WindowsLiveClient newClient() {
        return new WindowsLiveClient();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.service = new ProxyOAuth20ServiceImpl((DefaultApi20)new LiveApi(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, "wl.basic", null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl() {
        return "https://apis.live.net/v5.0/me";
    }

    @Override
    protected WindowsLiveProfile extractUserProfile(String body) {
        WindowsLiveProfile profile = new WindowsLiveProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.windowsLiveDefinition.getAllAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    @Override
    protected boolean requiresStateParameter() {
        return false;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

