/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.BaseOAuth20Client;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.google2.Google2Profile;
import org.scribe.builder.api.GoogleApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.oauth.ExtendedOAuth20ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Google2Client
extends BaseOAuth20Client<Google2Profile> {
    protected final String PROFILE_SCOPE = "https://www.googleapis.com/auth/userinfo.profile";
    protected final String EMAIL_SCOPE = "https://www.googleapis.com/auth/userinfo.email";
    protected Google2Scope scope = Google2Scope.EMAIL_AND_PROFILE;
    protected String scopeValue;

    public Google2Client() {
    }

    public Google2Client(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected Google2Client newClient() {
        Google2Client newClient = new Google2Client();
        newClient.setScope(this.scope);
        return newClient;
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        CommonHelper.assertNotNull((String)"scope", (Object)((Object)this.scope));
        this.scopeValue = this.scope == Google2Scope.EMAIL ? this.EMAIL_SCOPE : (this.scope == Google2Scope.PROFILE ? this.PROFILE_SCOPE : this.PROFILE_SCOPE + " " + this.EMAIL_SCOPE);
        this.service = new ExtendedOAuth20ServiceImpl(new GoogleApi20(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, this.scopeValue, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl() {
        return "https://www.googleapis.com/oauth2/v2/userinfo";
    }

    @Override
    protected Google2Profile extractUserProfile(String body) {
        Google2Profile profile = new Google2Profile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "id"));
            for (String attribute : OAuthAttributesDefinitions.google2Definition.getPrincipalAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
        }
        return profile;
    }

    public Google2Scope getScope() {
        return this.scope;
    }

    public void setScope(Google2Scope scope) {
        this.scope = scope;
    }

    @Override
    protected boolean requiresStateParameter() {
        return false;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Google2Scope {
        EMAIL,
        PROFILE,
        EMAIL_AND_PROFILE;

    }
}

