/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuth10Client;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.OAuthAttributesDefinitions;
import org.pac4j.oauth.profile.dropbox.DropBoxProfile;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.builder.api.DropBoxApi;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.model.Token;
import org.scribe.oauth.ProxyOAuth10aServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropBoxClient
extends BaseOAuth10Client<DropBoxProfile> {
    public DropBoxClient() {
    }

    public DropBoxClient(String key, String secret) {
        this.setKey(key);
        this.setSecret(secret);
    }

    protected DropBoxClient newClient() {
        return new DropBoxClient();
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        this.service = new ProxyOAuth10aServiceImpl((DefaultApi10a)new DropBoxApi(), new OAuthConfig(this.key, this.secret, this.callbackUrl, SignatureType.Header, null, null), this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    @Override
    protected String getProfileUrl() {
        return "https://api.dropbox.com/1/account/info";
    }

    @Override
    protected OAuthCredentials getOAuthCredentials(WebContext context) {
        Token tokenRequest = (Token)context.getSessionAttribute(this.getRequestTokenSessionAttributeName());
        logger.debug("tokenRequest : {}", (Object)tokenRequest);
        String token = tokenRequest.getToken();
        logger.debug("token = verifier : {}", (Object)token);
        return new OAuthCredentials(tokenRequest, token, token, this.getName());
    }

    @Override
    protected DropBoxProfile extractUserProfile(String body) {
        DropBoxProfile profile = new DropBoxProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(JsonHelper.get(json, "uid"));
            for (String attribute : OAuthAttributesDefinitions.dropBoxDefinition.getPrincipalAttributes()) {
                profile.addAttribute(attribute, JsonHelper.get(json, attribute));
            }
            if ((json = (JsonNode)JsonHelper.get(json, "quota_info")) != null) {
                for (String attribute : OAuthAttributesDefinitions.dropBoxDefinition.getOtherAttributes()) {
                    profile.addAttribute(attribute, JsonHelper.get(json, attribute));
                }
            }
        }
        return profile;
    }

    @Override
    protected boolean hasBeenCancelled(WebContext context) {
        return false;
    }
}

