/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Protocol;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.WordPressClient;
import org.pac4j.oauth.client.exception.OAuthCredentialsException;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.scribe.exceptions.OAuthException;
import org.scribe.model.OAuthRequest;
import org.scribe.model.ProxyOAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOAuthClient<U extends OAuth20Profile>
extends BaseClient<OAuthCredentials, U> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuthClient.class);
    protected OAuthService service;
    protected String key;
    protected String secret;
    protected int connectTimeout = 500;
    protected int readTimeout = 2000;
    protected String proxyHost = null;
    protected int proxyPort = 8080;

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"key", (String)this.key);
        CommonHelper.assertNotBlank((String)"secret", (String)this.secret);
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
    }

    public BaseOAuthClient<U> clone() {
        BaseOAuthClient newClient = (BaseOAuthClient)super.clone();
        newClient.setKey(this.key);
        newClient.setSecret(this.secret);
        newClient.setConnectTimeout(this.connectTimeout);
        newClient.setReadTimeout(this.readTimeout);
        newClient.setProxyHost(this.proxyHost);
        newClient.setProxyPort(this.proxyPort);
        return newClient;
    }

    protected String retrieveRedirectionUrl(WebContext context) {
        try {
            return this.retrieveAuthorizationUrl(context);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract String retrieveAuthorizationUrl(WebContext var1);

    protected OAuthCredentials retrieveCredentials(WebContext context) {
        if (this.hasBeenCancelled(context)) {
            logger.debug("authentication has been cancelled by user");
            return null;
        }
        try {
            boolean errorFound = false;
            OAuthCredentialsException oauthCredentialsException = new OAuthCredentialsException("Failed to retrieve OAuth credentials, error parameters found");
            String errorMessage = "";
            for (String key : OAuthCredentialsException.ERROR_NAMES) {
                String value = context.getRequestParameter(key);
                if (value == null) continue;
                errorFound = true;
                errorMessage = errorMessage + key + " : '" + value + "'; ";
                oauthCredentialsException.setErrorMessage(key, value);
            }
            if (errorFound) {
                logger.error(errorMessage);
                throw oauthCredentialsException;
            }
            return this.getOAuthCredentials(context);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract boolean hasBeenCancelled(WebContext var1);

    protected abstract OAuthCredentials getOAuthCredentials(WebContext var1);

    protected U retrieveUserProfile(OAuthCredentials credentials) {
        try {
            Token token = this.getAccessToken(credentials);
            return this.retrieveUserProfileFromToken(token);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public U getUserProfile(String accessToken) {
        this.init();
        try {
            Token token = new Token(accessToken, "");
            return this.retrieveUserProfileFromToken(token);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract Token getAccessToken(OAuthCredentials var1);

    protected U retrieveUserProfileFromToken(Token accessToken) {
        String body = this.sendRequestForData(accessToken, this.getProfileUrl());
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken : " + accessToken);
        }
        U profile = this.extractUserProfile(body);
        this.addAccessTokenToProfile(profile, accessToken);
        return profile;
    }

    protected abstract String getProfileUrl();

    protected String sendRequestForData(Token accessToken, String dataUrl) {
        logger.debug("accessToken : {} / dataUrl : {}", (Object)accessToken, (Object)dataUrl);
        long t0 = System.currentTimeMillis();
        ProxyOAuthRequest request = this.createProxyRequest(dataUrl);
        this.service.signRequest(accessToken, (OAuthRequest)request);
        if (this instanceof WordPressClient) {
            request.addHeader("Authorization", "Bearer " + accessToken.getToken());
        }
        Response response = request.send();
        int code = response.getCode();
        String body = response.getBody();
        long t1 = System.currentTimeMillis();
        logger.debug("Request took : " + (t1 - t0) + " ms for : " + dataUrl);
        logger.debug("response code : {} / response body : {}", (Object)code, (Object)body);
        if (code != 200) {
            logger.error("Failed to get data, code : " + code + " / body : " + body);
            throw new HttpCommunicationException(code, body);
        }
        return body;
    }

    public String sendRequestForData(OAuth10Profile profile, String dataUrl) {
        String secret = profile.getAccessSecret();
        Token accessToken = new Token(profile.getAccessToken(), secret == null ? "" : secret);
        return this.sendRequestForData(accessToken, dataUrl);
    }

    protected ProxyOAuthRequest createProxyRequest(String url) {
        return new ProxyOAuthRequest(Verb.GET, url, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
    }

    protected abstract U extractUserProfile(String var1);

    protected void addAccessTokenToProfile(U profile, Token accessToken) {
        if (profile != null) {
            String token = accessToken.getToken();
            logger.debug("add access_token : {} to profile", (Object)token);
            ((OAuth20Profile)((Object)profile)).setAccessToken(token);
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Protocol getProtocol() {
        return Protocol.OAUTH;
    }
}

