/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.context.WebContext;
import org.pac4j.oauth.client.BaseOAuthClient;
import org.pac4j.oauth.client.exception.OAuthCredentialsException;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.OAuth10Profile;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOAuth10Client<U extends OAuth10Profile>
extends BaseOAuthClient<U> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseOAuth10Client.class);
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String REQUEST_TOKEN = "requestToken";

    protected String getRequestTokenSessionAttributeName() {
        return this.getName() + "#" + REQUEST_TOKEN;
    }

    @Override
    protected String retrieveAuthorizationUrl(WebContext context) {
        Token requestToken = this.service.getRequestToken();
        logger.debug("requestToken : {}", (Object)requestToken);
        context.setSessionAttribute(this.getRequestTokenSessionAttributeName(), (Object)requestToken);
        String authorizationUrl = this.service.getAuthorizationUrl(requestToken);
        logger.debug("authorizationUrl : {}", (Object)authorizationUrl);
        return authorizationUrl;
    }

    @Override
    protected OAuthCredentials getOAuthCredentials(WebContext context) {
        String tokenParameter = context.getRequestParameter(OAUTH_TOKEN);
        String verifierParameter = context.getRequestParameter(OAUTH_VERIFIER);
        if (tokenParameter != null && verifierParameter != null) {
            Token tokenSession = (Token)context.getSessionAttribute(this.getRequestTokenSessionAttributeName());
            logger.debug("tokenRequest : {}", (Object)tokenSession);
            String token = OAuthEncoder.decode((String)tokenParameter);
            String verifier = OAuthEncoder.decode((String)verifierParameter);
            logger.debug("token : {} / verifier : {}", (Object)token, (Object)verifier);
            return new OAuthCredentials(tokenSession, token, verifier, this.getName());
        }
        String message = "No credential found";
        logger.error("No credential found");
        throw new OAuthCredentialsException("No credential found");
    }

    @Override
    protected Token getAccessToken(OAuthCredentials credentials) {
        Token tokenRequest = credentials.getRequestToken();
        String token = credentials.getToken();
        String verifier = credentials.getVerifier();
        logger.debug("tokenRequest : {}", (Object)tokenRequest);
        logger.debug("token : {}", (Object)token);
        logger.debug("verifier : {}", (Object)verifier);
        if (tokenRequest == null) {
            String message = "Token request expired";
            logger.error("Token request expired");
            throw new OAuthCredentialsException("Token request expired");
        }
        String savedToken = tokenRequest.getToken();
        logger.debug("savedToken : {}", (Object)savedToken);
        if (savedToken == null || !savedToken.equals(token)) {
            String message = "Token received : " + token + " is different from saved token : " + savedToken;
            logger.error(message);
            throw new OAuthCredentialsException(message);
        }
        Verifier clientVerifier = new Verifier(verifier);
        Token accessToken = this.service.getAccessToken(tokenRequest, clientVerifier);
        logger.debug("accessToken : {}", (Object)accessToken);
        return accessToken;
    }

    protected boolean isDirectRedirection() {
        return false;
    }

    @Override
    protected void addAccessTokenToProfile(U profile, Token accessToken) {
        super.addAccessTokenToProfile(profile, accessToken);
        ((OAuth10Profile)((Object)profile)).setAccessSecret(accessToken.getSecret());
    }
}

