/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import org.osgl.http.H;
import org.osgl.mvc.MvcConfig;
import org.osgl.mvc.result.Result;
import org.osgl.util.KVStore;
import org.osgl.util.S;

public class ErrorResult
extends Result {
    private static final ErrorResult _INSTANCE = new ErrorResult(H.Status.I_AM_A_TEAPOT){

        @Override
        public Integer errorCode() {
            return 1.payload().errorCode;
        }

        @Override
        public String getMessage() {
            return 1.payload().message;
        }

        @Override
        public H.Status status() {
            return 1.payload().status;
        }

        @Override
        public long timestamp() {
            return 1.payload().timestamp;
        }

        public synchronized Throwable getCause() {
            return 1.payload().cause;
        }

        @Override
        public ErrorResult attach(Object attachment) {
            1.payload().attach(attachment);
            return this;
        }

        @Override
        public <T> T attachment() {
            return (T)1.payload().attachment;
        }

        @Override
        public <T> T attachment(Class<T> type) {
            return (T)1.payload().attachment;
        }
    };
    private Integer errorCode;
    private Object attachment;

    public ErrorResult(H.Status status) {
        super(status, MvcConfig.errorMessage(status));
    }

    public ErrorResult(H.Status status, String message) {
        super(status, message);
    }

    public ErrorResult(H.Status status, String message, Object ... args) {
        super(status, message, args);
    }

    public ErrorResult(H.Status status, Throwable cause) {
        super(status, cause, MvcConfig.errorMessage(status), new Object[0]);
    }

    public ErrorResult(H.Status status, Throwable cause, String message, Object ... args) {
        super(status, cause, message, args);
    }

    public ErrorResult(H.Status status, Integer errorCode) {
        super(status, MvcConfig.errorMessage(status));
        this.errorCode = errorCode;
    }

    public ErrorResult(H.Status status, Integer errorCode, String message) {
        super(status, message);
        this.errorCode = errorCode;
    }

    public ErrorResult(H.Status status, Integer errorCode, String message, Object ... args) {
        super(status, message, args);
        this.errorCode = errorCode;
    }

    public ErrorResult(H.Status status, Integer errorCode, Throwable cause) {
        super(status, cause, MvcConfig.errorMessage(status), new Object[0]);
        this.errorCode = errorCode;
    }

    public ErrorResult(H.Status status, Integer errorCode, Throwable cause, String message, Object ... args) {
        super(status, cause, message, args);
        this.errorCode = errorCode;
    }

    public ErrorResult attach(Object attachment) {
        this.attachment = attachment;
        return this;
    }

    public <T> T attachment() {
        return (T)this.attachment;
    }

    public <T> T attachment(Class<T> type) {
        return (T)this.attachment;
    }

    public String toString() {
        return "HTTP/1.1 " + this.statusCode() + " " + this.getLocalizedMessage();
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder("{\"status\":").append(this.statusCode()).append(", \"message\":\"").append(this.getLocalizedMessage());
        Integer errorCode = this.errorCode();
        if (null != errorCode) {
            sb.append("\", \"error\":").append(errorCode);
        } else {
            sb.append("\"");
        }
        return sb.append(", \"timestamp\":").append(this.timestamp()).append("}").toString();
    }

    public KVStore toKVStore() {
        Object payload;
        KVStore store = new KVStore();
        store.putValue("status", (Object)this.statusCode());
        store.putValue("message", (Object)this.getLocalizedMessage());
        store.putValue("timestamp", (Object)this.timestamp());
        Integer code = this.errorCode();
        if (null != code) {
            store.putValue("code", (Object)code);
        }
        if (null != (payload = this.attachment())) {
            store.putValue("payload", payload);
        }
        return store;
    }

    public ErrorResult errorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    @Override
    protected void applyMessage(H.Request request, H.Response response) {
        MvcConfig.errorPageRenderer().apply(request, response, this);
    }

    protected static String defaultMessage(H.Status status) {
        return MvcConfig.errorMessage(status);
    }

    protected static boolean _localizedErrorMsg() {
        return MvcConfig.localizedErrorMsg();
    }

    public static ErrorResult of(H.Status status) {
        ErrorResult.touchPayload().status(status).message(MvcConfig.errorMessage(status));
        return _INSTANCE;
    }

    public static ErrorResult of(H.Status status, String message, Object ... args) {
        ErrorResult.touchPayload().status(status).message(S.fmt((String)message, (Object[])args));
        return _INSTANCE;
    }

    public static ErrorResult of(H.Status status, int errorCode) {
        ErrorResult.touchPayload().errorCode(errorCode);
        return ErrorResult.of(status);
    }

    public static ErrorResult of(H.Status status, int errorCode, String message, Object ... args) {
        ErrorResult.touchPayload().errorCode(errorCode);
        return ErrorResult.of(status, message, args);
    }

    public static ErrorResult of(H.Status status, int errorCode, Throwable cause) {
        return ErrorResult.of(status, errorCode, cause, cause.getMessage(), new Object[0]);
    }

    public static ErrorResult of(H.Status status, int errorCode, Throwable cause, String message, Object ... args) {
        ErrorResult.touchPayload().cause(cause);
        return ErrorResult.of(status, errorCode, message, args);
    }

    public static ErrorResult of(H.Status status, Throwable cause, String message, Object ... args) {
        ErrorResult.touchPayload().cause(cause);
        return ErrorResult.of(status, message, args);
    }
}

