/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc;

import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.http.HttpConfig;
import org.osgl.mvc.MvcConfig;
import org.osgl.util.C;

public class HttpContextManager {
    private static final C.List<Listener> listeners = C.newList();

    private static String sessionKey() {
        return MvcConfig.sessionCookieName;
    }

    private static String flashKey() {
        return MvcConfig.flashCookieName;
    }

    public static void init(H.Request request, H.Response response) {
        H.Request.current((H.Request)request);
        H.Response.current((H.Response)response);
        HttpContextManager.resolveSession(request);
        HttpContextManager.resolveFlash(request);
    }

    public static void save() {
        H.Response resp = H.Response.current();
        H.Session session = H.Session.current();
        HttpContextManager.serialize(session);
        H.Flash flash = H.Flash.current();
        HttpContextManager.serialize(flash);
    }

    public static void cleanUp() {
        H.cleanUp();
        listeners.accept(F.ON_SESSION_CLEAN_UP);
    }

    private static void resolveSession(H.Request request) {
        H.Cookie cookie = request.cookie(MvcConfig.sessionCookieName);
        H.Session session = H.Session.resolve((H.Cookie)cookie, (int)MvcConfig.sessionExpire);
        H.Session.current((H.Session)session);
    }

    private static void resolveFlash(H.Request request) {
        H.Cookie cookie = request.cookie(MvcConfig.flashCookieName);
        H.Flash.current((H.Flash)H.Flash.resolve((H.Cookie)cookie));
    }

    private static void serialize(H.Session session) {
        HttpContextManager.saveCookie(session.serialize(HttpContextManager.sessionKey()));
    }

    private static void serialize(H.Flash flash) {
        HttpContextManager.saveCookie(flash.serialize(HttpContextManager.flashKey()));
    }

    private static void saveCookie(H.Cookie cookie) {
        cookie.path(HttpConfig.contextPath()).secure(HttpConfig.isCookieSecure());
        H.Response resp = H.Response.current();
        resp.addCookie(cookie);
    }

    private static enum F {

        public static Lang.Visitor<Listener> ON_SESSION_CLEAN_UP = new Lang.Visitor<Listener>(){

            public void visit(Listener listener) throws Lang.Break {
                listener.onCleanUp();
            }
        };

        public static Lang.Visitor<Listener> onSessionResolved(final H.Session session) {
            return new Lang.Visitor<Listener>(){

                public void visit(Listener listener) throws Lang.Break {
                    listener.onSessionResolved(session);
                }
            };
        }
    }

    public static interface Listener {
        public void onSessionResolved(H.Session var1);

        public void onCleanUp();
    }
}

