/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http.util;

import org.osgl.http.H;
import org.osgl.util.S;

public class ContentTypeResolver {
    private static final int HC_JSON = "application/json".hashCode();
    private static final char[] TXT = new char[]{'t', 'e', 'x', 't'};
    private static final char[] IMG = new char[]{'i', 'm', 'a', 'g', 'e'};
    private static final char[] APP = new char[]{'a', 'p', 'p', 'l', 'i', 'c', 'a', 't', 'i', 'o', 'n'};
    private static final char[] MULTIPART = new char[]{'m', 'u', 'l', 't', 'i', 'p', 'a', 'r', 't'};
    private static final char[] AUDIO = new char[]{'a', 'u', 'd', 'i', 'o'};
    private static final char[] VIDEO = new char[]{'v', 'i', 'd', 'e', 'o'};
    private static final char[] HTML = new char[]{'h', 't', 'm', 'l'};
    private static final char[] PLAIN = new char[]{'p', 'l', 'a', 'i', 'n'};
    private static final char[] CSS = new char[]{'c', 's', 's'};
    private static final char[] CSV = new char[]{'c', 's', 'v'};
    private static final char[] JS = new char[]{'j', 'a', 'v', 'a', 's', 'c', 'r', 'i', 'p', 't'};
    private static final char[] JSON = new char[]{'j', 's', 'o', 'n'};
    private static final char[] XHTML = new char[]{'x', 'h', 't', 'm', 'l', '+', 'x', 'm', 'l'};
    private static final char[] FORM_URL_ENCODED = new char[]{'x', '-', 'w', 'w', 'w', '-', 'f', 'o', 'r', 'm', '-', 'u', 'r', 'l', 'e', 'n', 'c', 'o', 'd', 'e', 'd'};
    private static final char[] XML = new char[]{'x', 'm', 'l'};
    private static final char[] PDF = new char[]{'p', 'd', 'f'};
    private static final char[] YAML = new char[]{'y', 'a', 'm', 'l'};
    private static final char[] V_YAML = new char[]{'v', 'n', 'd', '.', 'y', 'a', 'm', 'l'};
    private static final char[] X_YAML = new char[]{'x', '-', 'y', 'a', 'm', 'l'};
    private static final char[] BMP = new char[]{'b', 'm', 'p'};
    private static final char[] GIF = new char[]{'g', 'i', 'f'};
    private static final char[] ICO = new char[]{'i', 'c', 'o'};
    private static final char[] JPEG = new char[]{'j', 'p', 'e', 'g'};
    private static final char[] PNG = new char[]{'p', 'n', 'g'};
    private static final char[] SVG = new char[]{'s', 'v', 'g', '+', 'x', 'm', 'l'};
    private static final char[] MPA = new char[]{'m', 'p', 'e', 'g'};
    private static final char[] MP3 = new char[]{'m', 'p', '3'};
    private static final char[] MOD = new char[]{'m', 'o', 'd'};
    private static final char[] WAV = new char[]{'w', 'a', 'v'};
    private static final char[] OGA = new char[]{'o', 'g', 'a'};
    private static final char[] MPEG = new char[]{'m', 'p', 'e', 'g'};
    private static final char[] MP4 = new char[]{'m', 'p', '4'};
    private static final char[] MOV = new char[]{'m', 'o', 'v'};
    private static final char[] WEBM = new char[]{'w', 'e', 'b', 'm'};
    private static final char[] FLV = new char[]{'x', '-', 'f', 'l', 'v'};
    private static final char[] OGG = new char[]{'o', 'g', 'g'};
    private static final char[] MSA = new char[]{'x', '-', 'm', 's', '-', 'a', 'p', 'p', 'l', 'i', 'c', 'a', 't', 'i', 'o', 'n'};

    public static H.Format resolve(String target) {
        return ContentTypeResolver.resolve(H.Format.UNKNOWN, target);
    }

    public static H.Format resolve(H.Format def, String target) {
        char[] trait;
        if (null == def) {
            def = H.Format.UNKNOWN;
        }
        if (null == target) {
            return def;
        }
        int targetLen = target.length();
        if (targetLen < 3) {
            return def;
        }
        char c = target.charAt(0);
        switch (c) {
            case 't': {
                trait = TXT;
                break;
            }
            case 'a': {
                c = target.charAt(1);
                if ('p' == c) {
                    trait = APP;
                    break;
                }
                if ('u' == c) {
                    trait = AUDIO;
                    break;
                }
                return def;
            }
            case 'i': {
                trait = IMG;
                break;
            }
            case 'm': {
                trait = MULTIPART;
                break;
            }
            case 'v': {
                trait = VIDEO;
                break;
            }
            default: {
                return def;
            }
        }
        int traitLen = trait.length;
        if (targetLen < traitLen + 4) {
            return def;
        }
        c = target.charAt(traitLen);
        if ('/' != c) {
            return def;
        }
        int start = traitLen + 1;
        if (trait == TXT) {
            return ContentTypeResolver.parseText(def, target, targetLen, start);
        }
        if (APP == trait) {
            return ContentTypeResolver.parseApplication(def, target, targetLen, start);
        }
        if (IMG == trait) {
            return ContentTypeResolver.parseImage(H.Format.PNG, target, targetLen, start);
        }
        if (MULTIPART == trait) {
            return ContentTypeResolver.parseMultipart(def, target, targetLen, start);
        }
        if (VIDEO == trait) {
            return ContentTypeResolver.parseVideo(H.Format.MP4, target, targetLen, start);
        }
        return ContentTypeResolver.parseAudio(H.Format.WAV, target, targetLen, start);
    }

    private static boolean isSeparator(char c) {
        return ',' == c || ';' == c;
    }

    private static H.Format verifySecondLevelTrait(H.Format def, String target, int targetLen, int start, char[] trait, H.Format candidate) {
        int len = trait.length + start;
        if (len == targetLen) {
            return candidate;
        }
        if (targetLen < len) {
            return def;
        }
        char c = target.charAt(len);
        return ContentTypeResolver.isSeparator(c) ? candidate : def;
    }

    private static H.Format parseMultipart(H.Format def, String target, int targetLen, int start) {
        return H.Format.FORM_MULTIPART_DATA;
    }

    private static H.Format parseText(H.Format def, String target, int targetLen, int start) {
        H.Format candidate;
        char[] trait;
        block0 : switch (target.charAt(start)) {
            case 'h': {
                trait = HTML;
                candidate = H.Format.HTML;
                break;
            }
            case 'c': {
                char c = target.charAt(start + 1);
                if ('s' == c) {
                    switch (target.charAt(start + 2)) {
                        case 'v': {
                            trait = CSV;
                            candidate = H.Format.CSV;
                            break block0;
                        }
                        case 's': {
                            trait = CSS;
                            candidate = H.Format.CSS;
                            break block0;
                        }
                    }
                    return def;
                }
                return def;
            }
            case 'p': {
                trait = PLAIN;
                candidate = H.Format.TXT;
                break;
            }
            case 'x': {
                char c = target.charAt(start + 1);
                if ('m' == c) {
                    trait = XML;
                    candidate = H.Format.XML;
                    break;
                }
                if ('-' == c) {
                    trait = X_YAML;
                    candidate = H.Format.YAML;
                    break;
                }
                return def;
            }
            case 'y': {
                trait = YAML;
                candidate = H.Format.YAML;
                break;
            }
            case 'j': {
                trait = JS;
                candidate = H.Format.JAVASCRIPT;
                break;
            }
            case 'v': {
                trait = V_YAML;
                candidate = H.Format.YAML;
                break;
            }
            default: {
                return def;
            }
        }
        return ContentTypeResolver.verifySecondLevelTrait(def, target, targetLen, start, trait, candidate);
    }

    private static H.Format parseApplication(H.Format def, String target, int targetLen, int start) {
        H.Format candidate;
        char[] trait;
        char c = target.charAt(start);
        switch (c) {
            case 'j': {
                c = target.charAt(start + 1);
                if ('s' == c) {
                    trait = JSON;
                    candidate = H.Format.JSON;
                    break;
                }
                if ('a' == c) {
                    trait = JS;
                    candidate = H.Format.JAVASCRIPT;
                    break;
                }
                return def;
            }
            case 'x': {
                c = target.charAt(start + 1);
                if ('m' == c) {
                    trait = XML;
                    candidate = H.Format.XML;
                    break;
                }
                if ('h' == c) {
                    trait = XHTML;
                    candidate = H.Format.HTML;
                    break;
                }
                if ('-' == c) {
                    c = target.charAt(start + 2);
                    if ('w' == c) {
                        trait = FORM_URL_ENCODED;
                        candidate = H.Format.FORM_URL_ENCODED;
                        break;
                    }
                    if ('y' == c) {
                        trait = X_YAML;
                        candidate = H.Format.YAML;
                        break;
                    }
                    if ('m' == c) {
                        trait = MSA;
                        candidate = H.Format.HTML;
                        break;
                    }
                    return def;
                }
                return def;
            }
            case 'p': {
                trait = PDF;
                candidate = H.Format.PDF;
                break;
            }
            case 'y': {
                trait = YAML;
                candidate = H.Format.YAML;
                break;
            }
            case 'v': {
                if (targetLen > start + 4 && '.' == target.charAt(start + 3)) {
                    return ContentTypeResolver.parseVnd(def, target, targetLen, start + 4);
                }
                return def;
            }
            default: {
                return def;
            }
        }
        return ContentTypeResolver.verifySecondLevelTrait(def, target, targetLen, start, trait, candidate);
    }

    private static H.Format parseImage(H.Format def, String target, int targetLen, int start) {
        H.Format candidate;
        char[] trait;
        char c = target.charAt(start);
        switch (c) {
            case 'p': {
                trait = PNG;
                candidate = H.Format.PNG;
                break;
            }
            case 'j': {
                trait = JPEG;
                candidate = H.Format.JPG;
                break;
            }
            case 'g': {
                trait = GIF;
                candidate = H.Format.GIF;
                break;
            }
            case 's': {
                trait = SVG;
                candidate = H.Format.SVG;
                break;
            }
            case 'b': {
                trait = BMP;
                candidate = H.Format.BMP;
                break;
            }
            case 'i': {
                trait = ICO;
                candidate = H.Format.ICO;
                break;
            }
            default: {
                return def;
            }
        }
        return ContentTypeResolver.verifySecondLevelTrait(def, target, targetLen, start, trait, candidate);
    }

    private static H.Format parseAudio(H.Format def, String target, int targetLen, int start) {
        H.Format candidate;
        char[] trait;
        char c = target.charAt(start);
        switch (c) {
            case 'm': {
                c = target.charAt(start + 1);
                if ('o' == c) {
                    trait = MOD;
                    candidate = H.Format.MOD;
                    break;
                }
                if ('p' == c) {
                    if (targetLen < 12) {
                        if ('3' == target.charAt(targetLen - 1)) {
                            return H.Format.MP3;
                        }
                        return H.Format.MPA;
                    }
                    if ('3' == target.charAt(start + 2) || '3' == target.charAt(start + 4)) {
                        return H.Format.MP3;
                    }
                    return H.Format.MPA;
                }
                return def;
            }
            case 'o': {
                trait = OGA;
                candidate = H.Format.OGA;
                break;
            }
            case 'w': {
                trait = WAV;
                candidate = H.Format.WAV;
                break;
            }
            default: {
                return def;
            }
        }
        return ContentTypeResolver.verifySecondLevelTrait(def, target, targetLen, start, trait, candidate);
    }

    private static H.Format parseVideo(H.Format def, String target, int targetLen, int start) {
        H.Format candidate;
        char[] trait;
        char c = target.charAt(start);
        switch (c) {
            case 'm': {
                c = target.charAt(start + 1);
                if ('o' == c) {
                    trait = MOV;
                    candidate = H.Format.MOV;
                    break;
                }
                if ('p' == c) {
                    c = target.charAt(start + 2);
                    if ('4' == c) {
                        trait = MP4;
                        candidate = H.Format.MP4;
                        break;
                    }
                    if ('e' == c) {
                        trait = MPEG;
                        candidate = H.Format.MPG;
                        break;
                    }
                    return def;
                }
                return def;
            }
            case 'o': {
                trait = OGG;
                candidate = H.Format.OGV;
                break;
            }
            case 'w': {
                trait = WEBM;
                candidate = H.Format.WEBM;
                break;
            }
            case 'x': {
                trait = FLV;
                candidate = H.Format.FLV;
                break;
            }
            default: {
                return def;
            }
        }
        return ContentTypeResolver.verifySecondLevelTrait(def, target, targetLen, start, trait, candidate);
    }

    private static H.Format parseVnd(H.Format def, String target, int targetLen, int start) {
        if ('y' == target.charAt(start)) {
            if (targetLen == start + 4 && target.regionMatches(start + 1, "yaml", 1, 3)) {
                return H.Format.YAML;
            }
            return def;
        }
        if ('m' == target.charAt(start)) {
            if (targetLen == start + "ms-excel".length()) {
                if (target.regionMatches(start + 1, "ms-excel", 1, "ms-excel".length() - 1)) {
                    return H.Format.XLS;
                }
                return def;
            }
            if (targetLen == start + "ms-word".length()) {
                if (target.regionMatches(start + 1, "ms-word", 1, "ms-word".length() - 1)) {
                    return H.Format.DOC;
                }
                return def;
            }
            return def;
        }
        if (target.indexOf("sheet", start) > -1) {
            return H.Format.XLSX;
        }
        if (target.indexOf("word", start) > -1) {
            return H.Format.DOCX;
        }
        return def;
    }

    public static H.Format resolveLegacy(String contentType) {
        H.Format fmt = H.Format.UNKNOWN;
        if (S.blank((String)contentType) || "*/*".equals(contentType)) {
            fmt = H.Format.UNKNOWN;
        } else if (contentType.startsWith("application/json")) {
            fmt = H.Format.JSON;
        } else if (contentType.startsWith("text/html")) {
            fmt = H.Format.HTML;
        } else if (contentType.startsWith("text/css")) {
            fmt = H.Format.CSS;
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            fmt = H.Format.FORM_URL_ENCODED;
        } else if (contentType.startsWith("multipart/form-data") || contentType.startsWith("multipart/mixed")) {
            fmt = H.Format.FORM_MULTIPART_DATA;
        } else if (contentType.startsWith("text/javascript")) {
            fmt = H.Format.JSON;
        } else if (contentType.startsWith("application/xml") || contentType.contains("text/xml")) {
            fmt = H.Format.XML;
        } else if (contentType.startsWith("image")) {
            fmt = contentType.contains("png") ? H.Format.PNG : (contentType.contains("jpg") || contentType.contains("jpeg") ? H.Format.JPG : (contentType.contains("gif") ? H.Format.GIF : (contentType.contains("svg") ? H.Format.SVG : (contentType.contains("ico") ? H.Format.ICO : (contentType.contains("bmp") ? H.Format.BMP : H.Format.PNG)))));
        } else if (contentType.contains("text/plain")) {
            fmt = H.Format.TXT;
        } else if (contentType.contains("csv") || contentType.contains("comma-separated-values")) {
            fmt = H.Format.CSV;
        } else if (contentType.contains("ms-excel")) {
            fmt = H.Format.XLS;
        } else if (contentType.contains("spreadsheetml")) {
            fmt = H.Format.XLSX;
        } else if (contentType.contains("pdf")) {
            fmt = H.Format.PDF;
        } else if (contentType.contains("msword")) {
            fmt = H.Format.DOC;
        } else if (contentType.contains("wordprocessingml")) {
            fmt = H.Format.DOCX;
        } else if (contentType.contains("rtf")) {
            fmt = H.Format.RTF;
        } else if (contentType.contains("yaml")) {
            fmt = H.Format.YAML;
        } else if (contentType.contains("audio")) {
            fmt = contentType.contains("mpeg3") ? H.Format.MP3 : (contentType.contains("mp") ? H.Format.MPA : (contentType.contains("mod") ? H.Format.MOD : (contentType.contains("wav") ? H.Format.WAV : (contentType.contains("ogg") ? H.Format.OGA : H.Format.WAV))));
        } else if (contentType.contains("video")) {
            fmt = contentType.contains("mp4") ? H.Format.MP4 : (contentType.contains("webm") ? H.Format.WEBM : (contentType.contains("ogg") ? H.Format.OGV : (contentType.contains("mov") ? H.Format.MOV : (contentType.contains("mpeg") ? H.Format.MPG : (contentType.contains("x-flv") ? H.Format.FLV : H.Format.MP4)))));
        }
        return fmt;
    }

    public static void main(String[] args) {
        String s = "application/x-ms-application";
        for (char c : s.toCharArray()) {
            System.out.print(", '" + c + "'");
        }
    }
}

