/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.EmptyGreatestComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class SortKeyDefinition
implements Serializable {
    private static StringLiteral defaultOrder = new StringLiteral("ascending");
    private static StringLiteral defaultCaseOrder = new StringLiteral("#default");
    private static StringLiteral defaultLanguage = new StringLiteral(StringValue.EMPTY_STRING);
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = null;
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Expression stable = null;
    protected StringCollator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    private transient AtomicComparer finalComparator = null;

    public void setSortKey(Expression exp) {
        this.sortKey = exp;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression exp) {
        this.order = exp;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression exp) {
        this.dataTypeExpression = exp;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression exp) {
        this.caseOrder = exp;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression exp) {
        this.language = exp;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationNameExpression(Expression collationName) {
        this.collationName = collationName;
    }

    public Expression getCollationNameExpression() {
        return this.collationName;
    }

    public void setCollation(StringCollator collation) {
        this.collation = collation;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression stable) {
        this.stable = stable;
    }

    public Expression getStable() {
        return this.stable;
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean emptyLeast) {
        this.emptyLeast = emptyLeast;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order instanceof Literal) || this.dataTypeExpression != null && !(this.dataTypeExpression instanceof Literal) || !(this.caseOrder instanceof Literal) || !(this.language instanceof Literal) || this.stable != null && !(this.stable instanceof Literal) || this.collationName != null && !(this.collationName instanceof Literal));
    }

    public SortKeyDefinition simplify(ExpressionVisitor visitor) throws XPathException {
        this.sortKey = visitor.simplify(this.sortKey);
        this.order = visitor.simplify(this.order);
        this.dataTypeExpression = visitor.simplify(this.dataTypeExpression);
        this.caseOrder = visitor.simplify(this.caseOrder);
        this.language = visitor.simplify(this.language);
        this.stable = visitor.simplify(this.stable);
        return this;
    }

    public AtomicComparer makeComparator(XPathContext context) throws XPathException {
        StringValue stableVal;
        String s;
        StringCollator stringCollator;
        String orderX = this.order.evaluateAsString(context).toString();
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.collation != null) {
            stringCollator = this.collation;
        } else {
            if (this.collationName != null) {
                URI collationURI;
                String cname = this.collationName.evaluateAsString(context).toString();
                try {
                    collationURI = new URI(cname);
                    if (!collationURI.isAbsolute()) {
                        if (this.baseURI == null) {
                            throw new XPathException("Collation URI is relative, and base URI is unknown");
                        }
                        URI base = new URI(this.baseURI);
                        collationURI = base.resolve(collationURI);
                    }
                }
                catch (URISyntaxException err) {
                    throw new XPathException("Collation name " + cname + " is not a valid URI: " + err);
                }
                try {
                    stringCollator = context.getCollation(collationURI.toString());
                }
                catch (XPathException e) {
                    if ("FOCH0002".equals(e.getErrorCodeLocalPart())) {
                        e.setErrorCode("XTDE1035");
                    }
                    throw e;
                }
            }
            String caseOrderX = this.caseOrder.evaluateAsString(context).toString();
            String languageX = this.language.evaluateAsString(context).toString();
            Properties props = new Properties();
            if (languageX.length() != 0) {
                props.setProperty("lang", languageX);
            }
            if (!caseOrderX.equals("#default")) {
                props.setProperty("case-order", caseOrderX);
            }
            stringCollator = Configuration.getPlatform().makeCollation(config, props, "");
        }
        AtomicComparer atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, this.sortKey.getItemType(th).getAtomizedItemType().getPrimitiveType(), context);
        if (this.dataTypeExpression == null) {
            if (!this.emptyLeast) {
                atomicComparer = new EmptyGreatestComparer(atomicComparer);
            }
        } else {
            String dataType = this.dataTypeExpression.evaluateAsString(context).toString();
            if (dataType.equals("text")) {
                atomicComparer = new TextComparer(atomicComparer);
            } else if (dataType.equals("number")) {
                atomicComparer = NumericComparer.getInstance();
            } else {
                XPathException err = new XPathException("data-type on xsl:sort must be 'text' or 'number'");
                err.setErrorCode("XTDE0030");
                throw err;
            }
        }
        if (this.stable != null && !(s = Whitespace.trim((stableVal = (StringValue)this.stable.evaluateItem(context)).getStringValue())).equals("yes") && !s.equals("no")) {
            XPathException err = new XPathException("Value of 'stable' on xsl:sort must be 'yes' or 'no'");
            err.setErrorCode("XTDE0030");
            throw err;
        }
        if (orderX.equals("ascending")) {
            return atomicComparer;
        }
        if (orderX.equals("descending")) {
            return new DescendingComparer(atomicComparer);
        }
        XPathException err1 = new XPathException("order must be 'ascending' or 'descending'");
        err1.setErrorCode("XTDE0030");
        throw err1;
    }

    public void setFinalComparator(AtomicComparer comp) {
        this.finalComparator = comp;
    }

    public AtomicComparer getFinalComparator() {
        return this.finalComparator;
    }
}

