/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.presentation;

import java.util.Hashtable;
import org.odftoolkit.odfdom.doc.presentation.OdfPresentationNotes;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.NodeList;

public class OdfSlide {
    DrawPageElement maSlideElement;
    private static Hashtable<DrawPageElement, OdfSlide> maSlideRepository = new Hashtable();

    private OdfSlide(DrawPageElement pageElement) {
        this.maSlideElement = pageElement;
    }

    public static OdfSlide getInstance(DrawPageElement pageElement) {
        if (maSlideRepository.containsKey(pageElement)) {
            return maSlideRepository.get(pageElement);
        }
        OdfSlide newSlide = new OdfSlide(pageElement);
        maSlideRepository.put(pageElement, newSlide);
        return newSlide;
    }

    public DrawPageElement getOdfElement() {
        return this.maSlideElement;
    }

    public int getSlideIndex() {
        OdfFileDom contentDom = (OdfFileDom)((Object)this.maSlideElement.getOwnerDocument());
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)((Object)slideNodes.item(i));
            if (slideEle != this.maSlideElement) continue;
            return i;
        }
        return -1;
    }

    public String getSlideName() {
        String slideName = this.maSlideElement.getDrawNameAttribute();
        if (slideName == null) {
            slideName = this.makeUniqueSlideName();
            this.maSlideElement.setDrawNameAttribute(slideName);
        }
        return slideName;
    }

    public void setSlideName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("slide name is null is not accepted in the presentation document");
        }
        OdfFileDom contentDom = (OdfFileDom)((Object)this.maSlideElement.getOwnerDocument());
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)((Object)slideNodes.item(i));
            OdfSlide slide = OdfSlide.getInstance(slideEle);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            throw new IllegalArgumentException("the given slide name is already exist in the current presentation document");
        }
        this.maSlideElement.setDrawNameAttribute(name);
    }

    public OdfPresentationNotes getNotesPage() {
        NodeList notesList = this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
        if (notesList.getLength() > 0) {
            PresentationNotesElement noteEle = (PresentationNotesElement)((Object)notesList.item(0));
            return OdfPresentationNotes.getInstance(noteEle);
        }
        return null;
    }

    private String makeUniqueSlideName() {
        int index = this.getSlideIndex();
        String slideName = "page" + (index + 1) + "-" + String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        return slideName;
    }

    public static enum SlideLayout {
        BLANK("blank"),
        TITLE_ONLY("title_only"),
        TITLE_OUTLINE("title_outline"),
        TITLE_PLUS_TEXT("title_text"),
        TITLE_PLUS_2_TEXT_BLOCK("title_two_text_block");

        private String mValue;

        private SlideLayout(String aValue) {
            this.mValue = aValue;
        }

        public String toString() {
            return this.mValue;
        }

        public static String toString(SlideLayout aEnum) {
            return aEnum.toString();
        }

        public static SlideLayout enumValueOf(String aString) {
            for (SlideLayout aIter : SlideLayout.values()) {
                if (!aString.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }
}

