/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util.jmx.internal;

import java.util.function.Supplier;

public abstract class MetricValue {
    private final String name;
    private final Supplier<Long> supplier;

    private MetricValue(String name, Supplier<Long> supplier) {
        this.name = name;
        this.supplier = supplier;
    }

    protected Supplier<Long> getSupplier() {
        return this.supplier;
    }

    public String getName() {
        return this.name;
    }

    public Long get() {
        Long value = this.supplier.get();
        return value == null ? 0L : value;
    }

    public abstract MetricValue combine(MetricValue var1);

    public static final class LatestMetricValue
    extends MetricValue {
        public LatestMetricValue(String name, Supplier<Long> supplier) {
            super(name, supplier);
        }

        @Override
        public MetricValue combine(MetricValue prior) {
            return new LatestMetricValue(this.getName(), () -> {
                Long thisValue = this.getSupplier().get();
                if (thisValue != null) {
                    return thisValue;
                }
                return prior.get();
            });
        }
    }

    public static final class TotalMetricValue
    extends MetricValue {
        public TotalMetricValue(String name, Supplier<Long> supplier) {
            super(name, supplier);
        }

        @Override
        public MetricValue combine(MetricValue prior) {
            return new TotalMetricValue(this.getName(), () -> prior.get() + this.get());
        }
    }
}

