/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.json.formatter;

import com.mongodb.kafka.connect.source.json.formatter.JsonWriterSettingsProvider;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public class SimplifiedJson
implements JsonWriterSettingsProvider {
    @Override
    public JsonWriterSettings getJsonWriterSettings() {
        return JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).binaryConverter((value, writer) -> writer.writeString(Base64.getEncoder().encodeToString(value.getData()))).dateTimeConverter((value, writer) -> {
            ZonedDateTime zonedDateTime = Instant.ofEpochMilli(value).atZone(ZoneOffset.UTC);
            writer.writeString(DateTimeFormatter.ISO_DATE_TIME.format(zonedDateTime));
        }).decimal128Converter((value, writer) -> writer.writeString(value.toString())).objectIdConverter((value, writer) -> writer.writeString(value.toHexString())).symbolConverter((value, writer) -> writer.writeString(value)).build();
    }
}

