/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.mongodb.operations;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class OperationHelper {
    private static final String DOCUMENT_KEY = "documentKey";
    private static final String FULL_DOCUMENT = "fullDocument";
    private static final String UPDATE_DESCRIPTION = "updateDescription";
    private static final String UPDATED_FIELDS = "updatedFields";
    private static final String REMOVED_FIELDS = "removedFields";
    private static final Set<String> UPDATE_DESCRIPTION_FIELDS = new HashSet<String>(Arrays.asList("updatedFields", "removedFields"));
    private static final String SET = "$set";
    private static final String UNSET = "$unset";
    private static final BsonString EMPTY_STRING = new BsonString("");

    static BsonDocument getDocumentKey(BsonDocument changeStreamDocument) {
        if (!changeStreamDocument.containsKey((Object)DOCUMENT_KEY)) {
            throw new DataException(String.format("Missing %s field: %s", DOCUMENT_KEY, changeStreamDocument.toJson()));
        }
        if (!changeStreamDocument.get((Object)DOCUMENT_KEY).isDocument()) {
            throw new DataException(String.format("Unexpected %s field type, expecting a document but found `%s`: %s", DOCUMENT_KEY, changeStreamDocument.get((Object)DOCUMENT_KEY), changeStreamDocument.toJson()));
        }
        return changeStreamDocument.getDocument((Object)DOCUMENT_KEY);
    }

    static boolean hasFullDocument(BsonDocument changeStreamDocument) {
        return changeStreamDocument.containsKey((Object)FULL_DOCUMENT);
    }

    static BsonDocument getFullDocument(BsonDocument changeStreamDocument) {
        if (!changeStreamDocument.containsKey((Object)FULL_DOCUMENT)) {
            throw new DataException(String.format("Missing %s field: %s", FULL_DOCUMENT, changeStreamDocument.toJson()));
        }
        if (!changeStreamDocument.get((Object)FULL_DOCUMENT).isDocument()) {
            throw new DataException(String.format("Unexpected %s field type, expecting a document but found `%s`: %s", FULL_DOCUMENT, changeStreamDocument.get((Object)FULL_DOCUMENT), changeStreamDocument.toJson()));
        }
        return changeStreamDocument.getDocument((Object)FULL_DOCUMENT);
    }

    static BsonDocument getUpdateDocument(BsonDocument changeStreamDocument) {
        if (!changeStreamDocument.containsKey((Object)UPDATE_DESCRIPTION)) {
            throw new DataException(String.format("Missing %s field: %s", UPDATE_DESCRIPTION, changeStreamDocument.toJson()));
        }
        if (!changeStreamDocument.get((Object)UPDATE_DESCRIPTION).isDocument()) {
            throw new DataException(String.format("Unexpected %s field type, expected a document found `%s`: %s", UPDATE_DESCRIPTION, changeStreamDocument.get((Object)UPDATE_DESCRIPTION), changeStreamDocument.toJson()));
        }
        BsonDocument updateDescription = changeStreamDocument.getDocument((Object)UPDATE_DESCRIPTION);
        HashSet updateDescriptionFields = new HashSet(updateDescription.keySet());
        updateDescriptionFields.removeAll(UPDATE_DESCRIPTION_FIELDS);
        if (!updateDescriptionFields.isEmpty()) {
            throw new DataException(String.format("Warning unexpected field(s) in %s %s. %s. Cannot process due to risk of data loss.", UPDATE_DESCRIPTION, updateDescriptionFields, updateDescription.toJson()));
        }
        if (!updateDescription.containsKey((Object)UPDATED_FIELDS)) {
            throw new DataException(String.format("Missing %s.%s field: %s", UPDATE_DESCRIPTION, UPDATED_FIELDS, updateDescription.toJson()));
        }
        if (!updateDescription.get((Object)UPDATED_FIELDS).isDocument()) {
            throw new DataException(String.format("Unexpected %s field type, expected a document but found `%s`: %s", UPDATE_DESCRIPTION, updateDescription, updateDescription.toJson()));
        }
        if (!updateDescription.containsKey((Object)REMOVED_FIELDS)) {
            throw new DataException(String.format("Missing %s.%s field: %s", UPDATE_DESCRIPTION, REMOVED_FIELDS, updateDescription.toJson()));
        }
        if (!updateDescription.get((Object)REMOVED_FIELDS).isArray()) {
            throw new DataException(String.format("Unexpected %s field type, expected an array but found `%s`: %s", REMOVED_FIELDS, updateDescription.get((Object)REMOVED_FIELDS), updateDescription.toJson()));
        }
        BsonDocument updatedFields = updateDescription.getDocument((Object)UPDATED_FIELDS);
        BsonArray removedFields = updateDescription.getArray((Object)REMOVED_FIELDS);
        BsonDocument unsetDocument = new BsonDocument();
        for (BsonValue removedField : removedFields) {
            if (!removedField.isString()) {
                throw new DataException(String.format("Unexpected value type in %s, expected an string but found `%s`: %s", REMOVED_FIELDS, removedField, updateDescription.toJson()));
            }
            unsetDocument.append(removedField.asString().getValue(), (BsonValue)EMPTY_STRING);
        }
        BsonDocument updateDocument = new BsonDocument(SET, (BsonValue)updatedFields);
        if (!unsetDocument.isEmpty()) {
            updateDocument.put(UNSET, (BsonValue)unsetDocument);
        }
        return updateDocument;
    }

    private OperationHelper() {
    }
}

