/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.mongodb;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class MongoDbUpdate
implements CdcOperation {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);
    private static final String JSON_DOC_FIELD_PATH = "patch";
    private static final String JSON_DOC_FIELD_AFTER = "after";
    public static final String INTERNAL_OPLOG_FIELD_V = "$v";
    private final EventFormat eventFormat;

    public MongoDbUpdate(EventFormat eventFormat) {
        this.eventFormat = eventFormat;
    }

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        try {
            if (EventFormat.ChangeStream.equals((Object)this.eventFormat)) {
                return this.handleChangeStreamEvent(doc);
            }
            if (EventFormat.Oplog.equals((Object)this.eventFormat)) {
                return this.handleOplogEvent(doc);
            }
            throw new UnsupportedOperationException(String.format("Unsupported event format '%s'.", new Object[]{this.eventFormat}));
        }
        catch (DataException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new DataException(exc.getMessage(), (Throwable)exc);
        }
    }

    private WriteModel<BsonDocument> handleOplogEvent(SinkDocument doc) {
        BsonDocument valueDoc = this.getDocumentValue(doc);
        if (!valueDoc.containsKey((Object)JSON_DOC_FIELD_PATH)) {
            throw new DataException(String.format("Update document missing `%s` field.", JSON_DOC_FIELD_PATH));
        }
        BsonDocument updateDoc = BsonDocument.parse((String)valueDoc.getString((Object)JSON_DOC_FIELD_PATH).getValue());
        updateDoc.remove((Object)INTERNAL_OPLOG_FIELD_V);
        if (updateDoc.containsKey((Object)"_id")) {
            BsonDocument filterDoc = new BsonDocument("_id", updateDoc.get((Object)"_id"));
            return new ReplaceOneModel((Bson)filterDoc, (Object)updateDoc, REPLACE_OPTIONS);
        }
        return new UpdateOneModel((Bson)this.getFilterDocByKeyId(doc), (Bson)updateDoc);
    }

    private WriteModel<BsonDocument> handleChangeStreamEvent(SinkDocument doc) {
        BsonDocument valueDoc = this.getDocumentValue(doc);
        if (!valueDoc.containsKey((Object)JSON_DOC_FIELD_AFTER)) {
            throw new DataException(String.format("Update document missing `%s` field.", JSON_DOC_FIELD_AFTER));
        }
        BsonDocument updateDoc = BsonDocument.parse((String)valueDoc.getString((Object)JSON_DOC_FIELD_AFTER).getValue());
        return new ReplaceOneModel((Bson)this.getFilterDocByKeyId(doc), (Object)updateDoc, REPLACE_OPTIONS);
    }

    private BsonDocument getFilterDocByKeyId(SinkDocument doc) {
        BsonDocument keyDoc = this.getDocumentKey(doc);
        if (!keyDoc.containsKey((Object)"id")) {
            throw new DataException(String.format("Update document missing `%s` field.", "id"));
        }
        return BsonDocument.parse((String)String.format("{%s: %s}", "_id", keyDoc.getString((Object)"id").getValue()));
    }

    private BsonDocument getDocumentKey(SinkDocument doc) {
        return doc.getKeyDoc().orElseThrow(() -> new DataException("Key document must not be missing for update operation"));
    }

    private BsonDocument getDocumentValue(SinkDocument doc) {
        return doc.getValueDoc().orElseThrow(() -> new DataException("Value document must not be missing for update operation"));
    }

    public static enum EventFormat {
        Oplog,
        ChangeStream;

    }
}

