/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.security.delegate;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.minbox.framework.security.delegate.SecurityStoreDelegate;
import org.minbox.framework.security.exception.SecurityException;
import org.minbox.framework.security.userdetails.DefaultSecurityUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.ObjectUtils;

public class DefaultSecurityStoreDelegate
implements SecurityStoreDelegate {
    static Logger logger = LoggerFactory.getLogger(DefaultSecurityStoreDelegate.class);
    static String DEFAULT_SELECT_USER_SQL = "SELECT UI_ID, UI_USER_NAME, UI_NICK_NAME, UI_PASSWORD, UI_EMAIL, UI_AGE, UI_ADDRESS, UI_IS_LOCKED, UI_IS_ENABLED, UI_STATUS, UI_CREATE_TIME FROM API_BOOT_USER_INFO WHERE UI_USER_NAME = ?";
    private DataSource dataSource;

    public DefaultSecurityStoreDelegate(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        DefaultSecurityUserDetails userDetails = this.findUser(username);
        logger.debug("Load user \uff1a{} complete.", (Object)username);
        return userDetails;
    }

    private DefaultSecurityUserDetails findUser(String username) {
        DefaultSecurityUserDetails defaultSecurityUserDetails;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(DEFAULT_SELECT_USER_SQL);
            ps.setString(1, username);
            resultSet = ps.executeQuery();
            defaultSecurityUserDetails = this.wrapperOneResult(DefaultSecurityUserDetails.class, resultSet);
        }
        catch (Exception e) {
            try {
                throw new UsernameNotFoundException("Username\uff1a" + username + "\uff0cnot found.");
            }
            catch (Throwable throwable) {
                DefaultSecurityStoreDelegate.closeResultSet(resultSet);
                DefaultSecurityStoreDelegate.closeStatement(ps);
                DefaultSecurityStoreDelegate.closeConnection(connection);
                throw throwable;
            }
        }
        DefaultSecurityStoreDelegate.closeResultSet(resultSet);
        DefaultSecurityStoreDelegate.closeStatement(ps);
        DefaultSecurityStoreDelegate.closeConnection(connection);
        return defaultSecurityUserDetails;
    }

    private static void closeConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private <T> T wrapperOneResult(Class<T> resultClass, ResultSet rs) throws SecurityException {
        T resultObj = null;
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                resultObj = resultClass.newInstance();
                for (int index = 1; index < columnCount + 1; ++index) {
                    Field field;
                    String columnName = metaData.getColumnName(index);
                    Object columnValue = rs.getObject(columnName);
                    if (columnValue == null) continue;
                    String fieldName = this.columnNameToFieldName(columnName);
                    try {
                        field = resultClass.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        try {
                            field = resultClass.getSuperclass().getDeclaredField(fieldName);
                        }
                        catch (NoSuchFieldException e2) {
                            throw new SecurityException("No such filed \uff1a " + fieldName);
                        }
                    }
                    field.setAccessible(true);
                    field.set(resultObj, columnValue);
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException("Encapsulation result set object encounters exception information\uff1a" + e.getMessage(), e);
        }
        return ObjectUtils.isEmpty(resultObj) ? null : resultObj;
    }

    private String columnNameToFieldName(String columnName) {
        String fieldName = columnName.toLowerCase();
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
    }
}

