/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.security;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public abstract class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    protected List<String> configureIgnoreUrls() {
        return Collections.emptyList();
    }

    public void configure(WebSecurity web) {
        WebSecurity.IgnoredRequestConfigurer ignoredRequestConfigurer = web.ignoring();
        this.configureIgnoreUrls().forEach(url -> {
            WebSecurity.IgnoredRequestConfigurer cfr_ignored_0 = (WebSecurity.IgnoredRequestConfigurer)ignoredRequestConfigurer.antMatchers(new String[]{url});
        });
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService()).passwordEncoder(this.passwordEncoder());
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity http) throws Exception {
        if (this.disableHttpBasic()) {
            http.httpBasic().disable();
        }
        if (this.disableCsrf()) {
            http.csrf().disable();
        }
        http.exceptionHandling().accessDeniedHandler(this.getAccessDeniedHandler());
        http.exceptionHandling().authenticationEntryPoint(this.getAuthenticationEntryPoint());
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected abstract AccessDeniedHandler getAccessDeniedHandler();

    protected abstract AuthenticationEntryPoint getAuthenticationEntryPoint();

    protected abstract boolean disableHttpBasic();

    protected abstract boolean disableCsrf();
}

