/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import javax.security.auth.login.Configuration;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.ldap.client.api.SaslCramMd5Request;
import org.apache.directory.ldap.client.api.SaslDigestMd5Request;
import org.apache.directory.ldap.client.api.SaslGssApiRequest;
import org.ldaptive.Credential;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.sasl.SecurityStrength;

public final class ApacheLdapSaslUtils {
    private ApacheLdapSaslUtils() {
    }

    protected static SaslDigestMd5Request createDigestMd5Request(String username, Credential credential, SaslConfig config) {
        DigestMd5Config c;
        SaslDigestMd5Request request = new SaslDigestMd5Request();
        if (username != null) {
            request.setUsername(username);
        }
        if (credential != null) {
            request.setCredentials(credential.getBytes());
        }
        if (config.getAuthorizationId() != null && !"".equals(config.getAuthorizationId())) {
            request.setAuthorizationId(config.getAuthorizationId());
        }
        if (config.getMutualAuthentication() != null) {
            request.setMutualAuthentication(config.getMutualAuthentication().booleanValue());
        }
        if (config.getQualityOfProtection() != null) {
            request.setQualityOfProtection(ApacheLdapSaslUtils.getQualityOfProtection(config.getQualityOfProtection()));
        }
        if (config.getSecurityStrength() != null) {
            request.setSecurityStrength(ApacheLdapSaslUtils.getSecurityStrength(config.getSecurityStrength()));
        }
        if (config instanceof DigestMd5Config && (c = (DigestMd5Config)config).getRealm() != null) {
            request.setRealmName(c.getRealm());
        }
        return request;
    }

    protected static SaslCramMd5Request createCramMd5Request(String username, Credential credential, SaslConfig config) {
        SaslCramMd5Request request = new SaslCramMd5Request();
        if (username != null) {
            request.setUsername(username);
        }
        if (credential != null) {
            request.setCredentials(credential.getBytes());
        }
        if (config.getAuthorizationId() != null && !"".equals(config.getAuthorizationId())) {
            request.setAuthorizationId(config.getAuthorizationId());
        }
        if (config.getMutualAuthentication() != null) {
            request.setMutualAuthentication(config.getMutualAuthentication().booleanValue());
        }
        if (config.getQualityOfProtection() != null) {
            request.setQualityOfProtection(ApacheLdapSaslUtils.getQualityOfProtection(config.getQualityOfProtection()));
        }
        if (config.getSecurityStrength() != null) {
            request.setSecurityStrength(ApacheLdapSaslUtils.getSecurityStrength(config.getSecurityStrength()));
        }
        return request;
    }

    protected static SaslGssApiRequest createGssApiRequest(String username, Credential credential, SaslConfig config) {
        String loginConfig;
        String kdcHost;
        String realm;
        GssApiConfig c;
        SaslGssApiRequest request = new SaslGssApiRequest();
        if (username != null) {
            request.setUsername(username);
        }
        if (credential != null) {
            request.setCredentials(credential.getBytes());
        }
        if (config.getAuthorizationId() != null) {
            request.setAuthorizationId(config.getAuthorizationId());
        }
        if (config.getMutualAuthentication() != null) {
            request.setMutualAuthentication(config.getMutualAuthentication().booleanValue());
        }
        if (config.getQualityOfProtection() != null) {
            request.setQualityOfProtection(ApacheLdapSaslUtils.getQualityOfProtection(config.getQualityOfProtection()));
        }
        if (config.getSecurityStrength() != null) {
            request.setSecurityStrength(ApacheLdapSaslUtils.getSecurityStrength(config.getSecurityStrength()));
        }
        if (config instanceof GssApiConfig && (c = (GssApiConfig)config).getRealm() != null) {
            request.setRealmName(c.getRealm());
        }
        if ((realm = System.getProperty("java.security.krb5.realm")) != null) {
            request.setRealmName(realm);
        }
        if ((kdcHost = System.getProperty("java.security.krb5.kdc")) != null) {
            request.setKdcHost(kdcHost);
        }
        if ((loginConfig = System.getProperty("java.security.auth.login.config")) != null) {
            request.setLoginModuleConfiguration(Configuration.getConfiguration());
        }
        request.setLoginContextName("com.sun.security.jgss.initiate");
        return request;
    }

    protected static SaslQoP getQualityOfProtection(QualityOfProtection qop) {
        SaslQoP e;
        switch (qop) {
            case AUTH: {
                e = SaslQoP.AUTH;
                break;
            }
            case AUTH_INT: {
                e = SaslQoP.AUTH_INT;
                break;
            }
            case AUTH_CONF: {
                e = SaslQoP.AUTH_CONF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL quality of protection: " + qop);
            }
        }
        return e;
    }

    protected static SaslSecurityStrength getSecurityStrength(SecurityStrength ss) {
        SaslSecurityStrength e;
        switch (ss) {
            case HIGH: {
                e = SaslSecurityStrength.HIGH;
                break;
            }
            case MEDIUM: {
                e = SaslSecurityStrength.MEDIUM;
                break;
            }
            case LOW: {
                e = SaslSecurityStrength.LOW;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL security strength: " + ss);
            }
        }
        return e;
    }
}

