/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016JF\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkCHRM;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "bluex", "", "bluey", "chromaticities", "", "getChromaticities", "()[D", "greenx", "greeny", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "redx", "redy", "whitex", "whitey", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "setChromaticities", "Companion", "plot-api"})
public final class PngChunkCHRM
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double whitex;
    private double whitey;
    private double redx;
    private double redy;
    private double greenx;
    private double greeny;
    private double bluex;
    private double bluey;
    @NotNull
    public static final String ID = "cHRM";

    public PngChunkCHRM(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(32, true);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.whitex), c.getData(), 0);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.whitey), c.getData(), 4);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.redx), c.getData(), 8);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.redy), c.getData(), 12);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.greenx), c.getData(), 16);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.greeny), c.getData(), 20);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.bluex), c.getData(), 24);
        PngHelperInternal.INSTANCE.writeInt4tobytes(PngHelperInternal.INSTANCE.doubleToInt100000(this.bluey), c.getData(), 28);
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 32) {
            throw new PngjException("bad chunk " + chunk);
        }
        this.whitex = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 0));
        this.whitey = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 4));
        this.redx = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 8));
        this.redy = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 12));
        this.greenx = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 16));
        this.greeny = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 20));
        this.bluex = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 24));
        this.bluey = PngHelperInternal.INSTANCE.intToDouble100000(PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 28));
    }

    public final void setChromaticities(double whitex, double whitey, double redx, double redy, double greenx, double greeny, double bluex, double bluey) {
        this.whitex = whitex;
        this.redx = redx;
        this.greenx = greenx;
        this.bluex = bluex;
        this.whitey = whitey;
        this.redy = redy;
        this.greeny = greeny;
        this.bluey = bluey;
    }

    @NotNull
    public final double[] getChromaticities() {
        double[] dArray = new double[]{this.whitex, this.whitey, this.redx, this.redy, this.greenx, this.greeny, this.bluex, this.bluey};
        return dArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkCHRM$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

