/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.drag.dao.OnlDragDataSourceDao;
import org.jeecg.modules.drag.service.IOnlDragExternalService;
import org.jeecg.modules.drag.service.IOnlDragSqlService;
import org.jeecg.modules.drag.util.a;
import org.jeecg.modules.drag.util.a.c;
import org.jeecg.modules.drag.util.e;
import org.jeecg.modules.drag.util.h;
import org.jeecg.modules.drag.util.k;
import org.jeecg.modules.drag.vo.DragDictModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="onlDragSqlServiceImpl")
public class l
implements IOnlDragSqlService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(l.class);
    @Autowired
    private OnlDragDataSourceDao onlDragDatasourceDao;
    @Lazy
    @Autowired
    private IOnlDragExternalService onlDragExternalService;
    @Autowired
    private e localCache;
    private final long b = 86400000L;

    @Override
    public Map<String, Object> querySqlData(String tableName, String compName, JSONObject condition, JSONObject config, Boolean isView) throws Exception {
        Map<String, Object> map = null;
        try {
            String compId = h.a(config.getString("compId"), tableName);
            Object cacheTableName = this.localCache.a(compId);
            String table = k.d(tableName);
            List<Map<String, String>> onlineTables = null;
            if (h.c(cacheTableName)) {
                onlineTables = this.onlDragDatasourceDao.getOnlineTable();
                table = k.a(tableName, onlineTables);
            }
            map = this.handleOnlineForm(table, compName, condition, config, onlineTables, isView);
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
            throw new Exception(e2.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> handleOnlineForm(String tableName, String compName, JSONObject condition, JSONObject config, List<Map<String, String>> onlineTables, Boolean isView) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        String compId = h.a(config.getString("compId"), tableName);
        Object cacheTableName = this.localCache.a(compId);
        Map<String, Object> timeMap = org.jeecg.modules.drag.util.a.a(condition);
        Map<String, Object> queryFields = org.jeecg.modules.drag.util.a.a(config, condition);
        boolean izCache = h.d(cacheTableName);
        List<String> tablesFields = null;
        if (!izCache && !CollectionUtils.isEmpty(onlineTables)) {
            List onlineTable = onlineTables.stream().filter(obj -> {
                if (obj.containsKey("table_name")) {
                    return tableName.equalsIgnoreCase((String)obj.get("table_name"));
                }
                return false;
            }).collect(Collectors.toList());
            for (Map tableObj : onlineTable) {
                tablesFields = this.onlDragDatasourceDao.getOnlineTableByHeadId((String)tableObj.get("id"));
            }
        }
        queryFields = c.a(queryFields, tablesFields, izCache);
        timeMap = c.a(timeMap, tablesFields, izCache);
        if (isView.booleanValue()) {
            this.localCache.a(compId, true, 86400000L);
        }
        List<Map<String, Object>> rawData = this.onlDragDatasourceDao.selectListBySql(tableName, queryFields, timeMap);
        if ("DoubleLineBar".equalsIgnoreCase(compName)) {
            List<Map<String, Object>> assistRawData = this.onlDragDatasourceDao.selectAssistListBySql(tableName, queryFields, timeMap);
            rawData.addAll(assistRawData);
        }
        List<Map<String, Object>> chartData = org.jeecg.modules.drag.util.a.a(config, rawData, compName);
        map.put("rawData", rawData);
        map.put("chartData", chartData);
        Map<String, List<DragDictModel>> dictItems = this.a(config, rawData);
        map.put("dictOptions", dictItems);
        return map;
    }

    private Map<String, List<DragDictModel>> a(JSONObject config, List<Map<String, Object>> rawData) {
        HashMap<String, List<DragDictModel>> dictItems = new HashMap<String, List<DragDictModel>>(5);
        try {
            JSONArray allFields = config.getJSONArray("name");
            JSONArray type = config.getJSONArray("type");
            if (!CollectionUtils.isEmpty((Collection)type)) {
                allFields.addAll((Collection)type);
            }
            ArrayList<String> codes = new ArrayList<String>(5);
            ArrayList<JSONObject> tableDictList = new ArrayList<JSONObject>(5);
            for (int i2 = 0; i2 < allFields.size(); ++i2) {
                List<String> ids;
                JSONObject object = allFields.getJSONObject(i2);
                String fieldName = object.getString("fieldName");
                String dictField = object.getString("dictField");
                String dictTable = object.getString("dictTable");
                String dictText = object.getString("dictText");
                String widgetType = object.getString("widgetType");
                if ("cat_tree".equalsIgnoreCase(widgetType)) {
                    if (dictItems.containsKey(dictField)) continue;
                    ids = rawData.stream().filter(Objects::nonNull).map(obj -> h.a(obj.get(fieldName), "").toString()).collect(Collectors.toList());
                    dictItems.put(dictField, this.onlDragExternalService.getCategoryTreeDictItems(ids));
                    continue;
                }
                if ("sel_user".equalsIgnoreCase(widgetType)) {
                    if (dictItems.containsKey(fieldName)) continue;
                    ids = rawData.stream().filter(Objects::nonNull).map(obj -> h.a(obj.get(fieldName), "").toString()).filter(obj -> h.d(obj)).collect(Collectors.toList());
                    dictItems.put(fieldName, this.onlDragExternalService.getUserDictItems(ids));
                    continue;
                }
                if ("sel_depart".equalsIgnoreCase(widgetType)) {
                    if (dictItems.containsKey(fieldName)) continue;
                    ids = rawData.stream().filter(Objects::nonNull).map(obj -> h.a(obj.get(fieldName), "").toString()).filter(obj -> h.d(obj)).collect(Collectors.toList());
                    dictItems.put(fieldName, this.onlDragExternalService.getDeptsDictItems(ids));
                    continue;
                }
                if ("sel_tree".equalsIgnoreCase(widgetType)) {
                    List<String> optionList;
                    if (dictItems.containsKey(fieldName) || !h.d(optionList = Arrays.asList(dictText.split(","))) || optionList.size() <= 2) continue;
                    List<DragDictModel> tableDictItems = this.onlDragExternalService.getTableDictItems(dictTable, optionList.get(2), optionList.get(0));
                    List ids2 = rawData.stream().filter(Objects::nonNull).map(obj -> h.a(obj.get(fieldName), "").toString()).filter(obj -> h.d(obj)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(tableDictItems)) {
                        tableDictItems = tableDictItems.stream().filter(item -> ids2.contains(item.getValue())).collect(Collectors.toList());
                    }
                    dictItems.put(fieldName, tableDictItems);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)dictTable) && StringUtils.isNotBlank((CharSequence)dictText)) {
                    tableDictList.add(object);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)dictField)) continue;
                codes.add(dictField);
            }
            if (!CollectionUtils.isEmpty(codes) || !CollectionUtils.isEmpty(tableDictList)) {
                Map<String, List<DragDictModel>> dictItemsExternal = this.onlDragExternalService.getManyDictItems(codes, tableDictList);
                for (Map.Entry<String, List<DragDictModel>> entry : dictItemsExternal.entrySet()) {
                    String key = entry.getKey();
                    List<DragDictModel> value = entry.getValue();
                    if (dictItems.containsKey(key)) {
                        ((List)dictItems.get(key)).addAll(value);
                        continue;
                    }
                    dictItems.put(key, value);
                }
            }
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        return dictItems;
    }

    @Override
    public Map<String, Object> getTableTotalData(String tableName, JSONObject condition, JSONObject config, Boolean isView) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        try {
            String compId = h.a(config.getString("compId"), tableName);
            Object cacheTableName = this.localCache.a(compId);
            String table = k.d(tableName);
            List<Map<String, String>> onlineTables = null;
            if (h.c(cacheTableName)) {
                onlineTables = this.onlDragDatasourceDao.getOnlineTable();
                table = k.a(tableName, onlineTables);
            }
            k.a(table, null);
            Map<String, Object> timeCondition = org.jeecg.modules.drag.util.a.a(condition);
            Map<String, Object> queryCondition = org.jeecg.modules.drag.util.a.b(config, condition);
            List<String> tablesFields = null;
            boolean izCache = h.d(cacheTableName);
            if (!izCache && !CollectionUtils.isEmpty(onlineTables)) {
                List onlineTable = onlineTables.stream().filter(obj -> {
                    if (obj.containsKey("table_name")) {
                        return tableName.equalsIgnoreCase((String)obj.get("table_name"));
                    }
                    return false;
                }).collect(Collectors.toList());
                for (Map tableObj : onlineTable) {
                    tablesFields = this.onlDragDatasourceDao.getOnlineTableByHeadId((String)tableObj.get("id"));
                }
            }
            timeCondition = c.a(timeCondition, tablesFields, izCache);
            queryCondition = c.a(queryCondition, tablesFields, izCache);
            if (isView.booleanValue()) {
                this.localCache.a(compId, true, 86400000L);
            }
            List<Map<String, Object>> rawData = this.onlDragDatasourceDao.selectTableBySql(tableName, queryCondition, timeCondition);
            map.put("rawData", rawData);
            Map<String, List<DragDictModel>> dictItems = this.a(config, rawData);
            map.put("dictOptions", dictItems);
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        return map;
    }

    @Override
    public Map<String, Object> getRawTableData(String tableName, JSONObject config, JSONArray condition) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        String table = k.d(tableName);
        if (condition != null && condition.size() > 0) {
            condition.forEach(obj -> {
                JSONObject field = (JSONObject)JSONObject.toJSON((Object)obj);
                String fieldName = field.getString("field");
                field.put(k.e(fieldName), field.get((Object)"fieldValue"));
            });
        }
        List<Map<String, Object>> rawData = this.onlDragDatasourceDao.selectRawTableList(tableName, condition);
        map.put("rawData", rawData);
        return map;
    }
}

