/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.naming.directory.SearchControls;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.jasig.services.persondir.support.BasePersonImpl;
import org.jasig.services.persondir.support.CaseInsensitiveAttributeNamedPersonImpl;
import org.jasig.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdaptivePersonAttributeDao
extends AbstractQueryPersonAttributeDao<SearchFilter> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseDN;
    private SearchControls searchControls;
    private ConnectionFactory connectionFactory;
    private SearchScope searchScope;
    private String searchFilter;
    private String[] attributes;

    public void setBaseDN(String dn) {
        this.baseDN = dn;
    }

    public void setSearchFilter(String filter) {
        this.searchFilter = filter;
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @PostConstruct
    public void initialize() {
        for (SearchScope scope : SearchScope.values()) {
            if (scope.ordinal() != this.searchControls.getSearchScope()) continue;
            this.searchScope = scope;
        }
        this.attributes = this.getResultAttributeMapping().keySet().toArray(new String[this.getResultAttributeMapping().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<IPersonAttributes> getPeopleForQuery(SearchFilter filter, String userName) {
        Connection connection = null;
        try {
            Response response;
            try {
                connection = this.connectionFactory.getConnection();
                connection.open();
            }
            catch (LdapException e) {
                throw new RuntimeException("Failed getting LDAP connection", e);
            }
            try {
                response = new SearchOperation(connection).execute((Request)this.createRequest(filter));
            }
            catch (LdapException e) {
                throw new RuntimeException("Failed executing LDAP query " + filter, e);
            }
            SearchResult result = (SearchResult)response.getResult();
            ArrayList<IPersonAttributes> peopleAttributes = new ArrayList<IPersonAttributes>(result.size());
            for (LdapEntry entry : result.getEntries()) {
                String userNameAttribute = this.getConfiguredUserNameAttribute();
                Map<String, List<Object>> attributes = this.convertLdapEntryToMap(entry);
                BasePersonImpl person = attributes.containsKey(userNameAttribute) ? new CaseInsensitiveAttributeNamedPersonImpl(userNameAttribute, attributes) : new CaseInsensitiveNamedPersonImpl(userName, attributes);
                peopleAttributes.add(person);
            }
            ArrayList<IPersonAttributes> arrayList = peopleAttributes;
            return arrayList;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Override
    protected SearchFilter appendAttributeToQuery(SearchFilter filter, String attribute, List<Object> values) {
        if (filter != null || values.size() <= 0) {
            throw new UnsupportedOperationException("Multiple attributes not supported.");
        }
        SearchFilter query = new SearchFilter(this.searchFilter);
        query.setParameter(0, (Object)values.get(0).toString());
        this.logger.debug("Constructed LDAP search query [{}]", (Object)query.format());
        return query;
    }

    private SearchRequest createRequest(SearchFilter filter) {
        SearchRequest request = new SearchRequest();
        request.setBaseDn(this.baseDN);
        request.setSearchFilter(filter);
        request.setReturnAttributes(this.attributes);
        request.setSearchScope(this.searchScope);
        request.setSizeLimit(this.searchControls.getCountLimit());
        request.setTimeLimit((long)this.searchControls.getTimeLimit());
        return request;
    }

    private Map<String, List<Object>> convertLdapEntryToMap(LdapEntry entry) {
        LinkedHashMap<String, List<Object>> attributeMap = new LinkedHashMap<String, List<Object>>(entry.size());
        for (LdapAttribute attr : entry.getAttributes()) {
            attributeMap.put(attr.getName(), new ArrayList(attr.getStringValues()));
        }
        this.logger.debug("Converted ldap DN entry [{}] to attribute map {}", (Object)entry.getDn(), (Object)((Object)attributeMap).toString());
        return attributeMap;
    }

    private void closeConnection(Connection context) {
        if (context != null && context.isOpen()) {
            try {
                context.close();
            }
            catch (Exception ex) {
                this.logger.warn("Could not close ldap connection", (Throwable)ex);
            }
        }
    }
}

