/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.report.ISourceFileLocator;

public class MultiSourceFileLocator
implements ISourceFileLocator {
    private final int tabWidth;
    private final List<ISourceFileLocator> delegates;

    public MultiSourceFileLocator(int tabWidth) {
        this.tabWidth = tabWidth;
        this.delegates = new ArrayList<ISourceFileLocator>();
    }

    public void add(ISourceFileLocator locator) {
        this.delegates.add(locator);
    }

    public Reader getSourceFile(String packageName, String fileName) throws IOException {
        for (ISourceFileLocator d : this.delegates) {
            Reader reader = d.getSourceFile(packageName, fileName);
            if (reader == null) continue;
            return reader;
        }
        return null;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }
}

