/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hswebframework.utils.time.DefaultDateFormatter;
import org.hswebframework.utils.time.SampleJDKDateFormatter;
import org.joda.time.DateTime;

public interface DateFormatter {
    public static final List<DateFormatter> supportFormatter = new ArrayList<DateFormatter>(Arrays.asList(new DefaultDateFormatter(Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2}"), "yyyyMMdd"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}"), "yyyy-MM-dd"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2}"), "yyyy/MM/dd"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]{2}\u6708[0-9]{2}\u65e5"), "yyyy\u5e74MM\u6708dd\u65e5"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]\u6708[0-9]\u65e5"), "yyyy\u5e74M\u6708d\u65e5"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]{2}\u6708[0-9]\u65e5"), "yyyy\u5e74MM\u6708d\u65e5"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]\u6708[0-9]{2}\u65e5"), "yyyy\u5e74M\u6708dd\u65e5"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9]"), "yyyy-M-d"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]"), "yyyy-MM-d"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9]{2}"), "yyyy-M-dd"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9]"), "yyyy/M/d"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]"), "yyyy/MM/d"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9]{2}"), "yyyy/M/dd"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy-MM-dd HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9] [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy-M-d HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9] [0-9]:[0-9]:[0-9]"), "yyyy-M-d H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9] [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy-MM-d HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy-M-dd HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]-[0-9]{2} [0-9]:[0-9]:[0-9]"), "yyyy-M-dd H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9] [0-9]:[0-9]:[0-9]"), "yyyy-MM-d H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy/MM/dd HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9] [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy/M/d HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9] [0-9]:[0-9]:[0-9]"), "yyyy/M/d H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9] [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy/MM/d HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy/M/dd HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]/[0-9]{2} [0-9]:[0-9]:[0-9]"), "yyyy/M/dd H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9] [0-9]:[0-9]:[0-9]"), "yyyy/MM/d H:m:s"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\\+[0-9]{4}"), "yyyy-MM-dd HH:mm:ssZ"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyy-MM-dd'T'HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\+[0-9]{4}"), "yyyy-MM-dd'T'HH:mm:ssZ"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]{2}\u6708[0-9]{2}\u65e5[0-9]{2}\u65f6[0-9]{2}\u5206[0-9]{2}\u79d2"), "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}\u5e74[0-9]{2}\u6708[0-9]{2}\u65e5 [0-9]{2}\u65f6[0-9]{2}\u5206[0-9]{2}\u79d2"), "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"), new DefaultDateFormatter(Pattern.compile("[0-9]{2}:[0-9]{2}:[0-9]{2}"), "HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}"), "yyyyMMdd HH:mm:ss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2}[0-9]{2}[0-9]{2}[0-9]{2}"), "yyyyMMddHHmmss"), new DefaultDateFormatter(Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2} [0-9]{2}[0-9]{2}[0-9]{2}"), "yyyyMMdd HHmmss"), new SampleJDKDateFormatter(str -> str.contains("\u5e74") && str.contains("CST") && str.split("[ ]").length == 6, () -> new SimpleDateFormat("yyyy\u5e74 MM\u6708 dd\u65e5 EEE HH:mm:ss 'CST'", Locale.CHINESE)), new SampleJDKDateFormatter(str -> str.contains("\u5e74") && str.contains("GMT") && str.split("[ ]").length == 6, () -> new SimpleDateFormat("yyyy\u5e74 MM\u6708 dd\u65e5 EEE HH:mm:ss 'GMT'", Locale.CHINESE)), new SampleJDKDateFormatter(str -> str.contains("CST") && str.split("[ ]").length == 6, () -> new SimpleDateFormat("EEE MMM dd HH:mm:ss 'CST' yyyy", Locale.US)), new SampleJDKDateFormatter(str -> str.contains("GMT") && str.split("[ ]").length == 6, () -> new SimpleDateFormat("EEE MMM dd HH:mm:ss 'GMT' yyyy", Locale.US)), new SampleJDKDateFormatter(str -> str.endsWith("AM") || str.endsWith("PM") && str.split("[ ]").length == 5, () -> new SimpleDateFormat("MMM d, yyyy K:m:s a", Locale.ENGLISH))));

    public boolean support(String var1);

    public Date format(String var1);

    public String toString(Date var1);

    public String getPattern();

    public static Date fromString(String dateString) {
        DateFormatter formatter = DateFormatter.getFormatter(dateString);
        if (formatter != null) {
            return formatter.format(dateString);
        }
        return null;
    }

    public static Date fromString(String dateString, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toString(Date date, String format) {
        if (null == date) {
            return null;
        }
        for (DateFormatter formatter : supportFormatter) {
            if (!formatter.getPattern().equals(format)) continue;
            return formatter.toString(date);
        }
        return new DateTime((Object)date).toString(format);
    }

    public static boolean isSupport(String dateString) {
        return dateString != null && dateString.length() >= 4 && supportFormatter.parallelStream().anyMatch(formatter -> formatter.support(dateString));
    }

    public static DateFormatter getFormatter(String dateString) {
        if (dateString == null || dateString.length() < 4) {
            return null;
        }
        for (DateFormatter formatter : supportFormatter) {
            if (!formatter.support(dateString)) continue;
            return formatter;
        }
        return null;
    }
}

