/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.Session;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class Search {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());

    private Search() {
    }

    public static FullTextEntityManager getFullTextEntityManager(EntityManager em) {
        if (em == null) {
            throw log.getNullEntityManagerPassedToFullEntityManagerCreationException();
        }
        if (em instanceof FullTextEntityManager) {
            return (FullTextEntityManager)em;
        }
        return org.hibernate.search.Search.getFullTextSession(Search.getSession(em));
    }

    private static Session getSession(EntityManager em) {
        try {
            return (Session)em.unwrap(Session.class);
        }
        catch (PersistenceException e) {
            throw new SearchException("Trying to use Hibernate Search with a non-Hibernate EntityManager", (Throwable)e);
        }
    }
}

