/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.jboss.logging.Logger;

public class PrimaryKey
extends Constraint {
    private static final Logger log = Logger.getLogger(PrimaryKey.class);

    @Override
    public void addColumn(Column column) {
        if (column.isNullable()) {
            if (log.isDebugEnabled()) {
                String columnName = column.getCanonicalName();
                log.debugf("Forcing column [%s] to be non-null as it is part of the primary key for table [%s]", (Object)columnName, (Object)this.getTableNameForLogging(column));
            }
            column.setNullable(false);
        }
        super.addColumn(column);
    }

    protected String getTableNameForLogging(Column column) {
        if (this.getTable() != null) {
            return this.getTable().getNameIdentifier().getCanonicalName();
        }
        if (column.getValue() != null && column.getValue().getTable() != null) {
            return column.getValue().getTable().getNameIdentifier().getCanonicalName();
        }
        return "<unknown>";
    }

    public String sqlConstraintString(Dialect dialect) {
        StringBuilder buf = new StringBuilder("primary key (");
        Iterator<Column> iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }

    @Override
    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        StringBuilder buf = new StringBuilder(dialect.getAddPrimaryKeyConstraintString(constraintName)).append('(');
        Iterator<Column> iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append(')').toString();
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "PK_";
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getName(), "PK-" + this.getName());
    }
}

