/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.commons.axon;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.axonframework.queryhandling.QueryExecutionException;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.responsetypes.ResponseTypes;
import org.hesperides.commons.axon.AxonResponseType;

public abstract class AxonQueries {
    private final QueryGateway queryGateway;

    protected AxonQueries(QueryGateway queryGateway) {
        this.queryGateway = queryGateway;
    }

    protected <R> R querySync(Object query, Class<R> responseType) {
        try {
            return (R)this.queryGateway.query(query, responseType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new QueryExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected <R> Optional<R> querySyncOptional(Object query, Class<R> responseType) {
        try {
            return (Optional)this.queryGateway.query(query, AxonResponseType.optionalInstancesOf(responseType)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new QueryExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected <R> List<R> querySyncList(Object query, Class<R> responseType) {
        try {
            return (List)this.queryGateway.query(query, ResponseTypes.multipleInstancesOf(responseType)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new QueryExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

