/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeAccessor;

public abstract class ExecutableNode
extends Node {
    @CompilerDirectives.CompilationFinal
    private Object engineRef;

    protected ExecutableNode(TruffleLanguage<?> language) {
        CompilerAsserts.neverPartOfCompilation();
        this.engineRef = language != null ? language : NodeAccessor.ENGINE.getCurrentPolyglotEngine();
        assert (language == null || this.getLanguageInfo() != null) : "Truffle language instance is not initialized.";
    }

    final TruffleLanguage<?> getLanguage() {
        Object ref = this.engineRef;
        if (ref instanceof TruffleLanguage) {
            return (TruffleLanguage)ref;
        }
        return null;
    }

    final void applyEngineRef(ExecutableNode node) {
        this.engineRef = node.engineRef;
    }

    final Object getEngine() {
        Object ref = this.engineRef;
        if (ref instanceof TruffleLanguage) {
            return NodeAccessor.ENGINE.getPolyglotEngine(NodeAccessor.LANGUAGE.getPolyglotLanguageInstance((TruffleLanguage)ref));
        }
        return ref;
    }

    final void setEngine(Object engine) {
        assert (!(this.engineRef instanceof TruffleLanguage)) : "not allowed overwrite language";
        this.engineRef = engine;
    }

    public abstract Object execute(VirtualFrame var1);

    public final LanguageInfo getLanguageInfo() {
        TruffleLanguage<?> language = this.getLanguage();
        if (language != null) {
            return NodeAccessor.LANGUAGE.getLanguageInfo(language);
        }
        return null;
    }

    public final <C extends TruffleLanguage> C getLanguage(Class<C> languageClass) {
        TruffleLanguage<?> language = this.getLanguage();
        if (language == null) {
            return null;
        }
        if (language.getClass() != languageClass) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new ClassCastException(String.format("Illegal language class specified. Expected '%s'.", language.getClass().getName()));
        }
        return (C)language;
    }
}

