/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.lib.PyObjectFunctionStr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.frame.VirtualFrame;

public class AbstractKwargsNode
extends PNodeWithContext {
    protected static PException handleNonMapping(VirtualFrame frame, PRaiseNode raise, int stackTop, NonMappingException e) {
        Object functionName = AbstractKwargsNode.getFunctionName(frame, stackTop);
        throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_AFTER_MUST_BE_MAPPING, functionName, e.getObject());
    }

    protected static PException handleSameKey(VirtualFrame frame, PRaiseNode raise, int stackTop, SameDictKeyException e) {
        Object functionName = AbstractKwargsNode.getFunctionName(frame, stackTop);
        throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_GOT_MULTIPLE_VALUES_FOR_KEYWORD_ARG, functionName, e.getKey());
    }

    private static Object getFunctionName(VirtualFrame frame, int stackTop) {
        Object callable = frame.getObject(stackTop - 2);
        return PyObjectFunctionStr.execute(callable);
    }
}

