/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.modules.ast.AstState;
import com.oracle.graal.python.builtins.modules.ast.Sst2ObjVisitorBase;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.truffle.api.CompilerDirectives;

final class Sst2ObjVisitor
extends Sst2ObjVisitorBase {
    private final AstState state;

    Sst2ObjVisitor(AstState state) {
        this.state = state;
    }

    @Override
    public Object visit(ModTy.Module node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsModule);
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_TYPE_IGNORES, this.seq2List(node.typeIgnores));
        return o;
    }

    @Override
    public Object visit(ModTy.Interactive node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsInteractive);
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        return o;
    }

    @Override
    public Object visit(ModTy.Expression node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsExpression);
        o.setAttribute(AstState.T_F_BODY, this.visitNonNull(node.body));
        return o;
    }

    @Override
    public Object visit(ModTy.FunctionType node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsFunctionType);
        o.setAttribute(AstState.T_F_ARGTYPES, this.seq2List(node.argTypes));
        o.setAttribute(AstState.T_F_RETURNS, this.visitNonNull(node.returns));
        return o;
    }

    @Override
    public Object visit(StmtTy.FunctionDef node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsFunctionDef);
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNonNull(node.name));
        o.setAttribute(AstState.T_F_ARGS, this.visitNonNull(node.args));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_DECORATOR_LIST, this.seq2List(node.decoratorList));
        o.setAttribute(AstState.T_F_RETURNS, this.visitNullable(node.returns));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.AsyncFunctionDef node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAsyncFunctionDef);
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNonNull(node.name));
        o.setAttribute(AstState.T_F_ARGS, this.visitNonNull(node.args));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_DECORATOR_LIST, this.seq2List(node.decoratorList));
        o.setAttribute(AstState.T_F_RETURNS, this.visitNullable(node.returns));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.ClassDef node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsClassDef);
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNonNull(node.name));
        o.setAttribute(AstState.T_F_BASES, this.seq2List(node.bases));
        o.setAttribute(AstState.T_F_KEYWORDS, this.seq2List(node.keywords));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_DECORATOR_LIST, this.seq2List(node.decoratorList));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Return node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsReturn);
        o.setAttribute(AstState.T_F_VALUE, this.visitNullable(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Delete node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsDelete);
        o.setAttribute(AstState.T_F_TARGETS, this.seq2List(node.targets));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Assign node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAssign);
        o.setAttribute(AstState.T_F_TARGETS, this.seq2List(node.targets));
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.AugAssign node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAugAssign);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_OP, this.visitNonNull(node.op));
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.AnnAssign node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAnnAssign);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_ANNOTATION, this.visitNonNull(node.annotation));
        o.setAttribute(AstState.T_F_VALUE, this.visitNullable(node.value));
        o.setAttribute(AstState.T_F_SIMPLE, Sst2ObjVisitor.visitNonNull(node.isSimple));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.For node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsFor);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_ITER, this.visitNonNull(node.iter));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.AsyncFor node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAsyncFor);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_ITER, this.visitNonNull(node.iter));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.While node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsWhile);
        o.setAttribute(AstState.T_F_TEST, this.visitNonNull(node.test));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.If node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsIf);
        o.setAttribute(AstState.T_F_TEST, this.visitNonNull(node.test));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.With node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsWith);
        o.setAttribute(AstState.T_F_ITEMS, this.seq2List(node.items));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.AsyncWith node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAsyncWith);
        o.setAttribute(AstState.T_F_ITEMS, this.seq2List(node.items));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Match node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatch);
        o.setAttribute(AstState.T_F_SUBJECT, this.visitNonNull(node.subject));
        o.setAttribute(AstState.T_F_CASES, this.seq2List(node.cases));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Raise node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsRaise);
        o.setAttribute(AstState.T_F_EXC, this.visitNullable(node.exc));
        o.setAttribute(AstState.T_F_CAUSE, this.visitNullable(node.cause));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Try node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsTry);
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_HANDLERS, this.seq2List(node.handlers));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        o.setAttribute(AstState.T_F_FINALBODY, this.seq2List(node.finalBody));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.TryStar node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsTryStar);
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        o.setAttribute(AstState.T_F_HANDLERS, this.seq2List(node.handlers));
        o.setAttribute(AstState.T_F_ORELSE, this.seq2List(node.orElse));
        o.setAttribute(AstState.T_F_FINALBODY, this.seq2List(node.finalBody));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Assert node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAssert);
        o.setAttribute(AstState.T_F_TEST, this.visitNonNull(node.test));
        o.setAttribute(AstState.T_F_MSG, this.visitNullable(node.msg));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Import node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsImport);
        o.setAttribute(AstState.T_F_NAMES, this.seq2List(node.names));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.ImportFrom node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsImportFrom);
        o.setAttribute(AstState.T_F_MODULE, Sst2ObjVisitor.visitNullable(node.module));
        o.setAttribute(AstState.T_F_NAMES, this.seq2List(node.names));
        o.setAttribute(AstState.T_F_LEVEL, Sst2ObjVisitor.visitNullable(node.level));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Global node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsGlobal);
        o.setAttribute(AstState.T_F_NAMES, this.seq2List(node.names));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Nonlocal node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsNonlocal);
        o.setAttribute(AstState.T_F_NAMES, this.seq2List(node.names));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Expr node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsExpr);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Pass node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsPass);
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Break node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsBreak);
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(StmtTy.Continue node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsContinue);
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.BoolOp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsBoolOp);
        o.setAttribute(AstState.T_F_OP, this.visitNonNull(node.op));
        o.setAttribute(AstState.T_F_VALUES, this.seq2List(node.values));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.NamedExpr node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsNamedExpr);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.BinOp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsBinOp);
        o.setAttribute(AstState.T_F_LEFT, this.visitNonNull(node.left));
        o.setAttribute(AstState.T_F_OP, this.visitNonNull(node.op));
        o.setAttribute(AstState.T_F_RIGHT, this.visitNonNull(node.right));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.UnaryOp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsUnaryOp);
        o.setAttribute(AstState.T_F_OP, this.visitNonNull(node.op));
        o.setAttribute(AstState.T_F_OPERAND, this.visitNonNull(node.operand));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Lambda node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsLambda);
        o.setAttribute(AstState.T_F_ARGS, this.visitNonNull(node.args));
        o.setAttribute(AstState.T_F_BODY, this.visitNonNull(node.body));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.IfExp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsIfExp);
        o.setAttribute(AstState.T_F_TEST, this.visitNonNull(node.test));
        o.setAttribute(AstState.T_F_BODY, this.visitNonNull(node.body));
        o.setAttribute(AstState.T_F_ORELSE, this.visitNonNull(node.orElse));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Dict node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsDict);
        o.setAttribute(AstState.T_F_KEYS, this.seq2List(node.keys));
        o.setAttribute(AstState.T_F_VALUES, this.seq2List(node.values));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Set node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsSet);
        o.setAttribute(AstState.T_F_ELTS, this.seq2List(node.elements));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.ListComp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsListComp);
        o.setAttribute(AstState.T_F_ELT, this.visitNonNull(node.element));
        o.setAttribute(AstState.T_F_GENERATORS, this.seq2List(node.generators));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.SetComp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsSetComp);
        o.setAttribute(AstState.T_F_ELT, this.visitNonNull(node.element));
        o.setAttribute(AstState.T_F_GENERATORS, this.seq2List(node.generators));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.DictComp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsDictComp);
        o.setAttribute(AstState.T_F_KEY, this.visitNonNull(node.key));
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_GENERATORS, this.seq2List(node.generators));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.GeneratorExp node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsGeneratorExp);
        o.setAttribute(AstState.T_F_ELT, this.visitNonNull(node.element));
        o.setAttribute(AstState.T_F_GENERATORS, this.seq2List(node.generators));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Await node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAwait);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Yield node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsYield);
        o.setAttribute(AstState.T_F_VALUE, this.visitNullable(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.YieldFrom node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsYieldFrom);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Compare node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsCompare);
        o.setAttribute(AstState.T_F_LEFT, this.visitNonNull(node.left));
        o.setAttribute(AstState.T_F_OPS, this.seq2List(node.ops));
        o.setAttribute(AstState.T_F_COMPARATORS, this.seq2List(node.comparators));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Call node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsCall);
        o.setAttribute(AstState.T_F_FUNC, this.visitNonNull(node.func));
        o.setAttribute(AstState.T_F_ARGS, this.seq2List(node.args));
        o.setAttribute(AstState.T_F_KEYWORDS, this.seq2List(node.keywords));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.FormattedValue node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsFormattedValue);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_CONVERSION, Sst2ObjVisitor.visitNonNull(node.conversion));
        o.setAttribute(AstState.T_F_FORMAT_SPEC, this.visitNullable(node.formatSpec));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.JoinedStr node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsJoinedStr);
        o.setAttribute(AstState.T_F_VALUES, this.seq2List(node.values));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Constant node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsConstant);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_KIND, this.visitNullableStringOrByteArray(node.kind));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Attribute node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAttribute);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_ATTR, Sst2ObjVisitor.visitNonNull(node.attr));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Subscript node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsSubscript);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_SLICE, this.visitNonNull(node.slice));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Starred node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsStarred);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Name node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsName);
        o.setAttribute(AstState.T_F_ID, Sst2ObjVisitor.visitNonNull(node.id));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.List node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsList);
        o.setAttribute(AstState.T_F_ELTS, this.seq2List(node.elements));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Tuple node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsTuple);
        o.setAttribute(AstState.T_F_ELTS, this.seq2List(node.elements));
        o.setAttribute(AstState.T_F_CTX, this.visitNonNull(node.context));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ExprTy.Slice node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsSlice);
        o.setAttribute(AstState.T_F_LOWER, this.visitNullable(node.lower));
        o.setAttribute(AstState.T_F_UPPER, this.visitNullable(node.upper));
        o.setAttribute(AstState.T_F_STEP, this.visitNullable(node.step));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    public Object visitNonNull(ExprContextTy v) {
        switch (v) {
            case Load: {
                return this.state.singletonLoad;
            }
            case Store: {
                return this.state.singletonStore;
            }
            case Del: {
                return this.state.singletonDel;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public Object visitNonNull(BoolOpTy v) {
        switch (v) {
            case And: {
                return this.state.singletonAnd;
            }
            case Or: {
                return this.state.singletonOr;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public Object visitNonNull(OperatorTy v) {
        switch (v) {
            case Add: {
                return this.state.singletonAdd;
            }
            case Sub: {
                return this.state.singletonSub;
            }
            case Mult: {
                return this.state.singletonMult;
            }
            case MatMult: {
                return this.state.singletonMatMult;
            }
            case Div: {
                return this.state.singletonDiv;
            }
            case Mod: {
                return this.state.singletonMod;
            }
            case Pow: {
                return this.state.singletonPow;
            }
            case LShift: {
                return this.state.singletonLShift;
            }
            case RShift: {
                return this.state.singletonRShift;
            }
            case BitOr: {
                return this.state.singletonBitOr;
            }
            case BitXor: {
                return this.state.singletonBitXor;
            }
            case BitAnd: {
                return this.state.singletonBitAnd;
            }
            case FloorDiv: {
                return this.state.singletonFloorDiv;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public Object visitNonNull(UnaryOpTy v) {
        switch (v) {
            case Invert: {
                return this.state.singletonInvert;
            }
            case Not: {
                return this.state.singletonNot;
            }
            case UAdd: {
                return this.state.singletonUAdd;
            }
            case USub: {
                return this.state.singletonUSub;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public Object visitNonNull(CmpOpTy v) {
        switch (v) {
            case Eq: {
                return this.state.singletonEq;
            }
            case NotEq: {
                return this.state.singletonNotEq;
            }
            case Lt: {
                return this.state.singletonLt;
            }
            case LtE: {
                return this.state.singletonLtE;
            }
            case Gt: {
                return this.state.singletonGt;
            }
            case GtE: {
                return this.state.singletonGtE;
            }
            case Is: {
                return this.state.singletonIs;
            }
            case IsNot: {
                return this.state.singletonIsNot;
            }
            case In: {
                return this.state.singletonIn;
            }
            case NotIn: {
                return this.state.singletonNotIn;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    public Object visit(ComprehensionTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsComprehensionTy);
        o.setAttribute(AstState.T_F_TARGET, this.visitNonNull(node.target));
        o.setAttribute(AstState.T_F_ITER, this.visitNonNull(node.iter));
        o.setAttribute(AstState.T_F_IFS, this.seq2List(node.ifs));
        o.setAttribute(AstState.T_F_IS_ASYNC, Sst2ObjVisitor.visitNonNull(node.isAsync));
        return o;
    }

    @Override
    public Object visit(ExceptHandlerTy.ExceptHandler node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsExceptHandler);
        o.setAttribute(AstState.T_F_TYPE, this.visitNullable(node.type));
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNullable(node.name));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(ArgumentsTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsArgumentsTy);
        o.setAttribute(AstState.T_F_POSONLYARGS, this.seq2List(node.posOnlyArgs));
        o.setAttribute(AstState.T_F_ARGS, this.seq2List(node.args));
        o.setAttribute(AstState.T_F_VARARG, this.visitNullable(node.varArg));
        o.setAttribute(AstState.T_F_KWONLYARGS, this.seq2List(node.kwOnlyArgs));
        o.setAttribute(AstState.T_F_KW_DEFAULTS, this.seq2List(node.kwDefaults));
        o.setAttribute(AstState.T_F_KWARG, this.visitNullable(node.kwArg));
        o.setAttribute(AstState.T_F_DEFAULTS, this.seq2List(node.defaults));
        return o;
    }

    @Override
    public Object visit(ArgTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsArgTy);
        o.setAttribute(AstState.T_F_ARG, Sst2ObjVisitor.visitNonNull(node.arg));
        o.setAttribute(AstState.T_F_ANNOTATION, this.visitNullable(node.annotation));
        o.setAttribute(AstState.T_F_TYPE_COMMENT, this.visitNullableStringOrByteArray(node.typeComment));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(KeywordTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsKeywordTy);
        o.setAttribute(AstState.T_F_ARG, Sst2ObjVisitor.visitNullable(node.arg));
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(AliasTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsAliasTy);
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNonNull(node.name));
        o.setAttribute(AstState.T_F_ASNAME, Sst2ObjVisitor.visitNullable(node.asName));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(WithItemTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsWithItemTy);
        o.setAttribute(AstState.T_F_CONTEXT_EXPR, this.visitNonNull(node.contextExpr));
        o.setAttribute(AstState.T_F_OPTIONAL_VARS, this.visitNullable(node.optionalVars));
        return o;
    }

    @Override
    public Object visit(MatchCaseTy node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchCaseTy);
        o.setAttribute(AstState.T_F_PATTERN, this.visitNonNull(node.pattern));
        o.setAttribute(AstState.T_F_GUARD, this.visitNullable(node.guard));
        o.setAttribute(AstState.T_F_BODY, this.seq2List(node.body));
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchValue node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchValue);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchSingleton node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchSingleton);
        o.setAttribute(AstState.T_F_VALUE, this.visitNonNull(node.value));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchSequence node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchSequence);
        o.setAttribute(AstState.T_F_PATTERNS, this.seq2List(node.patterns));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchMapping node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchMapping);
        o.setAttribute(AstState.T_F_KEYS, this.seq2List(node.keys));
        o.setAttribute(AstState.T_F_PATTERNS, this.seq2List(node.patterns));
        o.setAttribute(AstState.T_F_REST, Sst2ObjVisitor.visitNullable(node.rest));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchClass node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchClass);
        o.setAttribute(AstState.T_F_CLS, this.visitNonNull(node.cls));
        o.setAttribute(AstState.T_F_PATTERNS, this.seq2List(node.patterns));
        o.setAttribute(AstState.T_F_KWD_ATTRS, this.seq2List(node.kwdAttrs));
        o.setAttribute(AstState.T_F_KWD_PATTERNS, this.seq2List(node.kwdPatterns));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchStar node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchStar);
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNullable(node.name));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchAs node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchAs);
        o.setAttribute(AstState.T_F_PATTERN, this.visitNullable(node.pattern));
        o.setAttribute(AstState.T_F_NAME, Sst2ObjVisitor.visitNullable(node.name));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(PatternTy.MatchOr node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsMatchOr);
        o.setAttribute(AstState.T_F_PATTERNS, this.seq2List(node.patterns));
        Sst2ObjVisitor.fillSourceRangeAttributes(o, node.getSourceRange());
        return o;
    }

    @Override
    public Object visit(TypeIgnoreTy.TypeIgnore node) {
        PythonObject o = this.factory.createPythonObject(this.state.clsTypeIgnore);
        o.setAttribute(AstState.T_F_LINENO, Sst2ObjVisitor.visitNonNull(node.lineNo));
        o.setAttribute(AstState.T_F_TAG, this.visitNonNullStringOrByteArray(node.tag));
        return o;
    }
}

