/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SelectModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectAsFileDescriptor;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyTimeFromObjectNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.util.ArrayBuilder;
import com.oracle.graal.python.util.IntArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.TimeUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.List;

@CoreFunctions(defineModule="select")
public final class SelectModuleBuiltins
extends PythonBuiltins {
    public SelectModuleBuiltins() {
        this.addBuiltinConstant("error", (Object)PythonErrorType.OSError);
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SelectModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        if (PosixConstants.PIPE_BUF.defined) {
            this.addBuiltinConstant("PIPE_BUF", (Object)PosixConstants.PIPE_BUF.getValueIfDefined());
        }
    }

    @Builtin(name="select", minNumOfPositionalArgs=3, parameterNames={"rlist", "wlist", "xlist", "timeout"})
    @GenerateNodeFactory
    static abstract class SelectNode
    extends PythonBuiltinNode {
        SelectNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PTuple doGeneric(VirtualFrame frame, Object rlist, Object wlist, Object xlist, Object timeout, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile isNotNoneTimeout, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectGetItem callGetItemNode, @Cached ListNodes.FastConstructListNode constructListNode, @Cached PyTimeFromObjectNode pyTimeFromObjectNode, @Cached PyObjectAsFileDescriptor asFileDescriptor, @Cached InlinedBranchProfile notSelectableBranch, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupportLibrary.SelectResult result;
            ObjAndFDList readFDs = SelectNode.seq2set(frame, inliningTarget, rlist, sizeNode, asFileDescriptor, callGetItemNode, constructListNode, raiseNode);
            ObjAndFDList writeFDs = SelectNode.seq2set(frame, inliningTarget, wlist, sizeNode, asFileDescriptor, callGetItemNode, constructListNode, raiseNode);
            ObjAndFDList xFDs = SelectNode.seq2set(frame, inliningTarget, xlist, sizeNode, asFileDescriptor, callGetItemNode, constructListNode, raiseNode);
            PosixSupportLibrary.Timeval timeoutval = null;
            if (!PGuards.isPNone(timeout)) {
                isNotNoneTimeout.enter(inliningTarget);
                timeoutval = TimeUtils.pyTimeAsTimeval(pyTimeFromObjectNode.execute(frame, inliningTarget, timeout, PyTimeFromObjectNode.RoundType.TIMEOUT, 1000000000L));
                if (timeoutval.getSeconds() < 0L) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "timeout");
                }
            }
            try {
                gil.release(true);
                try {
                    result = posixLib.select(PosixSupport.get(inliningTarget), readFDs.fds, writeFDs.fds, xFDs.fds, timeoutval);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.ChannelNotSelectableException e) {
                notSelectableBranch.enter(inliningTarget);
                return factory.createTuple(new Object[]{rlist, wlist, xlist});
            }
            return factory.createTuple(new PList[]{SelectNode.toList(result.getReadFds(), readFDs, factory), SelectNode.toList(result.getWriteFds(), writeFDs, factory), SelectNode.toList(result.getErrorFds(), xFDs, factory)});
        }

        private static PList toList(boolean[] result, ObjAndFDList fds, PythonObjectFactory factory) {
            Object[] resultObjs = new Object[result.length];
            int resultObjsIdx = 0;
            for (int i = 0; i < fds.fds.length; ++i) {
                if (!result[i]) continue;
                resultObjs[resultObjsIdx++] = fds.objects[i];
            }
            return factory.createList(PythonUtils.arrayCopyOf(resultObjs, resultObjsIdx));
        }

        private static ObjAndFDList seq2set(VirtualFrame frame, Node inliningTarget, Object sequence, PyObjectSizeNode sizeNode, PyObjectAsFileDescriptor asFileDescriptor, PyObjectGetItem callGetItemNode, ListNodes.FastConstructListNode constructListNode, PRaiseNode.Lazy raiseNode) {
            ArrayBuilder<Object> objects = new ArrayBuilder<Object>();
            IntArrayBuilder fds = new IntArrayBuilder();
            PSequence pSequence = constructListNode.execute((Frame)frame, inliningTarget, sequence);
            for (int i = 0; i < sizeNode.execute((Frame)frame, inliningTarget, sequence); ++i) {
                Object pythonObject = callGetItemNode.execute((Frame)frame, inliningTarget, pSequence, i);
                objects.add(pythonObject);
                int fd = asFileDescriptor.execute((Frame)frame, inliningTarget, pythonObject);
                if (fd >= PosixConstants.FD_SETSIZE.value) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.FILE_DESCRIPTOR_OUT_OF_RANGE_IN_SELECT);
                }
                fds.add(fd);
            }
            return new ObjAndFDList(objects.toArray(new Object[0]), fds.toArray());
        }

        @CompilerDirectives.ValueType
        private static final class ObjAndFDList {
            private final Object[] objects;
            private final int[] fds;

            private ObjAndFDList(Object[] objects, int[] fds) {
                this.objects = objects;
                this.fds = fds;
            }
        }
    }
}

