/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.helpers;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.helpers.ReflectionProxy;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ReflectionProxyHelper {
    private static final Field hField = ReflectionUtil.lookupField(Proxy.class, (String)"h");

    private static Object toStringInvocationHandler(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("toString")) {
            return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
        }
        if (method.getName().equals("hashCode") || method.getName().equals("equals") || method.getName().equals("invoke")) {
            throw VMError.shouldNotReachHere("You should not call " + method + " on an instance of " + proxy.getClass() + " during image building.");
        }
        throw VMError.shouldNotReachHere("Unknown method " + method + " called on an instance of " + proxy.getClass() + ".");
    }

    public static void setDefaultInvocationHandler(Proxy proxyInstance) {
        VMError.guarantee(ReflectionProxy.class.isAssignableFrom(proxyInstance.getClass()));
        try {
            hField.set(proxyInstance, ReflectionProxyHelper::toStringInvocationHandler);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

