/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaType;

abstract class JNIAccessibleMember {
    private final JNIAccessibleClass declaringClass;
    @UnknownObjectField(types={IdentityHashMap.class}, canBeNull=true)
    private Map<Class<?>, Void> hidingSubclasses;

    JNIAccessibleMember(JNIAccessibleClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public JNIAccessibleClass getDeclaringClass() {
        return this.declaringClass;
    }

    boolean isDiscoverableIn(Class<?> clazz) {
        Class<?> declaring = this.declaringClass.getClassObject();
        assert (clazz != null && declaring.isAssignableFrom(clazz));
        if (this.hidingSubclasses != null && !clazz.equals(declaring)) {
            Class<?> sup;
            if (this.hidingSubclasses.containsKey(clazz)) {
                return false;
            }
            if (declaring.isInterface()) {
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (!declaring.isAssignableFrom(iface) || this.isDiscoverableIn(iface)) continue;
                    return false;
                }
            }
            if ((sup = clazz.getSuperclass()) != null && declaring.isAssignableFrom(sup) && !this.isDiscoverableIn(sup)) {
                return false;
            }
        }
        return true;
    }

    void setHidingSubclasses(HostedMetaAccess metaAccess, Predicate<Class<?>> predicate) {
        assert (this.hidingSubclasses == null) : "must be set exactly once";
        ResolvedJavaType declaringType = metaAccess.lookupJavaType((Class)this.declaringClass.getClassObject());
        this.hidingSubclasses = this.findHidingSubclasses((HostedType)declaringType, predicate, null);
    }

    private Map<Class<?>, Void> findHidingSubclasses(HostedType type, Predicate<Class<?>> predicate, Map<Class<?>, Void> existing) {
        Map<Class<?>, Void> map = existing;
        for (HostedType subType : type.getSubTypes()) {
            if (subType.isInstantiated() || subType.getWrapped().isInTypeCheck()) {
                Class<?> subclass = subType.getJavaClass();
                if (predicate.test(subclass)) {
                    if (map == null) {
                        map = new IdentityHashMap();
                    }
                    map.put(subclass, null);
                    continue;
                }
                map = this.findHidingSubclasses(subType, predicate, map);
                continue;
            }
            assert (this.findHidingSubclasses(subType, predicate, null) == null) : "Class hiding a member exists in the image, but its superclass does not";
        }
        return map;
    }
}

