/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointErrors;
import com.oracle.svm.core.c.function.CEntryPointNativeFunctions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Isolates;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.impl.IsolateSupport;
import org.graalvm.word.WordFactory;

public final class IsolateSupportImpl
implements IsolateSupport {
    private static final String ISOLATES_DISABLED_MESSAGE = "Spawning of multiple isolates is disabled, use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.SpawnIsolates, "+") + " option.";

    static void initialize() {
        ImageSingletons.add(IsolateSupport.class, (Object)new IsolateSupportImpl());
    }

    private IsolateSupportImpl() {
    }

    public IsolateThread createIsolate(Isolates.CreateIsolateParameters parameters) throws Isolates.IsolateException {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            throw new Isolates.IsolateException(ISOLATES_DISABLED_MESSAGE);
        }
        CEntryPointCreateIsolateParameters params = (CEntryPointCreateIsolateParameters)StackValue.get(CEntryPointCreateIsolateParameters.class);
        params.setReservedSpaceSize(parameters.getReservedAddressSpaceSize());
        params.setVersion(1);
        CEntryPointNativeFunctions.IsolateThreadPointer isolateThreadPtr = (CEntryPointNativeFunctions.IsolateThreadPointer)StackValue.get(CEntryPointNativeFunctions.IsolateThreadPointer.class);
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.createIsolate(params, (CEntryPointNativeFunctions.IsolatePointer)WordFactory.nullPointer(), isolateThreadPtr));
        return isolateThreadPtr.read();
    }

    public IsolateThread attachCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        CEntryPointNativeFunctions.IsolateThreadPointer isolateThread = (CEntryPointNativeFunctions.IsolateThreadPointer)StackValue.get(CEntryPointNativeFunctions.IsolateThreadPointer.class);
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.attachThread(isolate, isolateThread));
        return isolateThread.read();
    }

    public IsolateThread getCurrentThread(Isolate isolate) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getCurrentThread(isolate);
    }

    public Isolate getIsolate(IsolateThread thread) throws Isolates.IsolateException {
        return CEntryPointNativeFunctions.getIsolate(thread);
    }

    public void detachThread(IsolateThread thread) throws Isolates.IsolateException {
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.detachThread(thread));
    }

    public void tearDownIsolate(IsolateThread thread) throws Isolates.IsolateException {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            throw new Isolates.IsolateException(ISOLATES_DISABLED_MESSAGE);
        }
        IsolateSupportImpl.throwOnError(CEntryPointNativeFunctions.tearDownIsolate(thread));
    }

    private static void throwOnError(int code) {
        if (code != 0) {
            String message = CEntryPointErrors.getDescription(code);
            throw new Isolates.IsolateException(message);
        }
    }
}

