/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class TimeToChronoUnitConverter {
    private static final Map<TimeUnit, ChronoUnit> TIME_UNIT_TO_CHRONO_UNIT = new HashMap<TimeUnit, ChronoUnit>();

    private TimeToChronoUnitConverter() {
    }

    public static ChronoUnit of(TimeUnit unit) {
        return Optional.ofNullable(TIME_UNIT_TO_CHRONO_UNIT.get((Object)unit)).orElseThrow(() -> new IllegalArgumentException("Unsupported TimeUnit."));
    }

    static {
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.DAYS, ChronoUnit.DAYS);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.HOURS, ChronoUnit.HOURS);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.MINUTES, ChronoUnit.MINUTES);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.SECONDS, ChronoUnit.SECONDS);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.MILLISECONDS, ChronoUnit.MILLIS);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.MICROSECONDS, ChronoUnit.MICROS);
        TIME_UNIT_TO_CHRONO_UNIT.put(TimeUnit.NANOSECONDS, ChronoUnit.NANOS);
    }
}

