/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.fluentlenium.core.FluentContainer;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.components.LazyComponents;
import org.fluentlenium.core.events.ContainerAnnotationsEventsRegistry;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.hook.DefaultHookChainBuilder;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.inject.ComponentAndProxy;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.ContainerFluentControl;
import org.fluentlenium.core.inject.ContainerInstantiator;
import org.fluentlenium.core.inject.DefaultContainerContext;
import org.fluentlenium.core.inject.ElementLocatorSearchContext;
import org.fluentlenium.core.inject.FluentElementInjectionSupportValidator;
import org.fluentlenium.core.inject.FluentInjectControl;
import org.fluentlenium.core.inject.FluentInjectException;
import org.fluentlenium.core.inject.FluentInjectFieldInitializer;
import org.fluentlenium.core.inject.FluentInjectHookDefinitionAdder;
import org.fluentlenium.core.inject.InjectionAnnotationSupport;
import org.fluentlenium.core.inject.InjectionElementLocator;
import org.fluentlenium.core.inject.InjectionElementLocatorFactory;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class FluentInjector
implements FluentInjectControl {
    private final Map<Class, Object> containerInstances = new IdentityHashMap<Class, Object>();
    private final Map<Object, ContainerContext> containerContexts = new IdentityHashMap<Object, ContainerContext>();
    private final Map<Object, ContainerAnnotationsEventsRegistry> eventsContainerSupport = new IdentityHashMap<Object, ContainerAnnotationsEventsRegistry>();
    private final FluentControl fluentControl;
    private final ComponentsManager componentsManager;
    private final ContainerInstantiator containerInstantiator;
    private final DefaultHookChainBuilder hookChainBuilder;
    private final EventsRegistry eventsRegistry;
    private final FluentElementInjectionSupportValidator injectionSupportValidator;
    private final FluentInjectFieldInitializer fieldInitializer;
    private final FluentInjectHookDefinitionAdder hookDefinitionAdder = new FluentInjectHookDefinitionAdder();

    public FluentInjector(FluentControl control, EventsRegistry eventsRegistry, ComponentsManager componentsManager, ContainerInstantiator instantiator) {
        this.fluentControl = control;
        this.eventsRegistry = eventsRegistry;
        this.componentsManager = componentsManager;
        this.containerInstantiator = instantiator;
        this.hookChainBuilder = new DefaultHookChainBuilder(control, componentsManager.getInstantiator());
        this.injectionSupportValidator = new FluentElementInjectionSupportValidator(componentsManager);
        this.fieldInitializer = new FluentInjectFieldInitializer(componentsManager, this.injectionSupportValidator);
    }

    public void release() {
        this.containerInstances.clear();
        for (ContainerAnnotationsEventsRegistry support : this.eventsContainerSupport.values()) {
            support.close();
        }
        this.eventsContainerSupport.clear();
        this.containerContexts.clear();
        this.componentsManager.release();
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        T container = this.containerInstantiator.newInstance(cls, null);
        this.inject(container);
        return container;
    }

    @Override
    public ContainerContext inject(Object container) {
        this.initContainer(container, null, (SearchContext)this.fluentControl.getDriver());
        this.inject(container, null, (SearchContext)this.fluentControl.getDriver());
        return this.containerContexts.get(container);
    }

    @Override
    public ContainerContext injectComponent(Object componentContainer, Object parentContainer, SearchContext searchContext) {
        this.initContainerContext(componentContainer, parentContainer, searchContext);
        this.inject(componentContainer, parentContainer, searchContext);
        return this.containerContexts.get(componentContainer);
    }

    private void inject(Object container, Object parentContainer, SearchContext searchContext) {
        this.initParentContainer(container, parentContainer);
        this.initFluentElements(container, searchContext);
        this.initChildrenContainers(container, searchContext);
    }

    private void initContainer(Object container, Object parentContainer, SearchContext searchContext) {
        this.initContainerContext(container, parentContainer, searchContext);
        if (container instanceof FluentContainer) {
            ((FluentContainer)container).initFluent(new ContainerFluentControl(this.fluentControl, this.containerContexts.get(container)));
        }
        this.initEventAnnotations(container);
    }

    private void initContainerContext(Object container, Object parentContainer, SearchContext searchContext) {
        ContainerContext parentContainerContext = parentContainer == null ? null : this.containerContexts.get(parentContainer);
        DefaultContainerContext containerContext = new DefaultContainerContext(container, parentContainerContext, searchContext);
        this.containerContexts.put(container, containerContext);
        if (parentContainerContext != null) {
            containerContext.getHookDefinitions().addAll(parentContainerContext.getHookDefinitions());
        }
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            this.hookDefinitionAdder.addHookDefinitions(cls.getDeclaredAnnotations(), containerContext.getHookDefinitions());
            cls = cls.getSuperclass();
        }
    }

    private void initEventAnnotations(Object container) {
        if (this.eventsRegistry != null && !this.eventsContainerSupport.containsKey(container)) {
            this.eventsContainerSupport.put(container, new ContainerAnnotationsEventsRegistry(this.eventsRegistry, container));
        }
    }

    private static boolean isClassSupported(Class<?> cls) {
        return cls != Object.class && cls != null;
    }

    private void initParentContainer(Object container, Object parentContainer) {
        this.forAllDeclaredFieldsInHierarchyOf(container, field -> {
            if (InjectionAnnotationSupport.isParent(field)) {
                try {
                    ReflectionUtils.set(field, container, parentContainer);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new FluentInjectException("Can't set field " + field + " with value " + parentContainer, e);
                }
            }
        });
    }

    private void initChildrenContainers(Object container, SearchContext searchContext) {
        this.forAllDeclaredFieldsInHierarchyOf(container, field -> {
            if (InjectionAnnotationSupport.isContainer(field)) {
                Class<?> fieldClass = field.getType();
                Object existingChildContainer = this.containerInstances.get(fieldClass);
                if (existingChildContainer == null) {
                    Object childContainer = this.containerInstantiator.newInstance(fieldClass, this.containerContexts.get(container));
                    this.initContainer(childContainer, container, searchContext);
                    this.setFieldInContainer((Field)field, container, childContainer);
                    this.containerInstances.put(fieldClass, childContainer);
                    this.inject(childContainer, container, searchContext);
                } else {
                    this.setFieldInContainer((Field)field, container, existingChildContainer);
                }
            }
        });
    }

    private void setFieldInContainer(Field field, Object container, Object value) {
        try {
            ReflectionUtils.set(field, container, value);
        }
        catch (IllegalAccessException e) {
            throw new FluentInjectException("Can't set field " + field + " with value " + value, e);
        }
    }

    private void initFluentElements(Object container, SearchContext searchContext) {
        ContainerContext containerContext = this.containerContexts.get(container);
        this.forAllDeclaredFieldsInHierarchyOf(container, field -> {
            if (this.injectionSupportValidator.isSupported(container, (Field)field)) {
                ArrayList fieldHookDefinitions = new ArrayList(containerContext.getHookDefinitions());
                this.hookDefinitionAdder.addHookDefinitions(field.getAnnotations(), fieldHookDefinitions);
                InjectionElementLocatorFactory locatorFactory = new InjectionElementLocatorFactory(searchContext, this.fluentControl.getCapabilities());
                InjectionElementLocator locator = locatorFactory.createLocator((Field)field);
                if (locator != null) {
                    ComponentAndProxy<?, ?> fieldValue = this.fieldInitializer.initFieldElements(locator, (Field)field);
                    this.injectComponent(fieldValue, locator, container, (Field)field, fieldHookDefinitions);
                }
            }
        });
    }

    private void injectComponent(ComponentAndProxy fieldValue, ElementLocator locator, Object container, Field field, ArrayList<HookDefinition<?>> fieldHookDefinitions) {
        if (fieldValue != null) {
            LocatorProxies.setHooks(fieldValue.getProxy(), this.hookChainBuilder, fieldHookDefinitions);
            try {
                ReflectionUtils.set(field, container, fieldValue.getComponent());
            }
            catch (IllegalAccessException e) {
                throw new FluentInjectException("Unable to find an accessible constructor with an argument of type WebElement in " + field.getType(), e);
            }
            if (fieldValue.getComponent() instanceof Iterable && this.isLazyComponentsAndNotInitialized(fieldValue.getComponent())) {
                LazyComponents lazyComponents = (LazyComponents)fieldValue.getComponent();
                lazyComponents.addLazyComponentsListener(componentMap -> {
                    for (Map.Entry componentEntry : componentMap.entrySet()) {
                        this.injectComponent(componentEntry.getValue(), container, (SearchContext)componentEntry.getKey());
                    }
                });
            } else {
                ElementLocatorSearchContext componentSearchContext = new ElementLocatorSearchContext(locator);
                this.injectComponent(fieldValue.getComponent(), container, componentSearchContext);
            }
        }
    }

    private boolean isLazyComponentsAndNotInitialized(Object component) {
        if (component instanceof LazyComponents) {
            LazyComponents lazyComponents = (LazyComponents)component;
            return lazyComponents.isLazy() && !lazyComponents.isLazyInitialized();
        }
        return false;
    }

    private void forAllDeclaredFieldsInHierarchyOf(Object container, Consumer<Field> fieldConsumer) {
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                fieldConsumer.accept(field);
            }
            cls = cls.getSuperclass();
        }
    }
}

