/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.inject.ComponentAndProxy;
import org.fluentlenium.core.inject.FluentElementInjectionSupportValidator;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

final class FluentInjectFieldInitializer {
    private final ComponentsManager componentsManager;
    private final FluentElementInjectionSupportValidator injectionSupportValidator;

    FluentInjectFieldInitializer(ComponentsManager componentsManager, FluentElementInjectionSupportValidator injectionSupportValidator) {
        this.componentsManager = Objects.requireNonNull(componentsManager);
        this.injectionSupportValidator = Objects.requireNonNull(injectionSupportValidator);
    }

    ComponentAndProxy<?, ?> initFieldElements(ElementLocator locator, Field field) {
        ComponentAndProxy<Object, Object> fieldValue = null;
        if (this.injectionSupportValidator.isComponent(field)) {
            fieldValue = this.initFieldAsComponent(locator, field);
        } else if (this.injectionSupportValidator.isComponentList(field)) {
            fieldValue = this.initFieldAsComponentList(locator, field);
        } else if (FluentElementInjectionSupportValidator.isListOfFluentWebElement(field)) {
            fieldValue = this.initFieldAsListOfFluentWebElement(locator, field);
        } else if (this.injectionSupportValidator.isListOfComponent(field)) {
            fieldValue = this.initFieldAsListOfComponent(locator, field);
        } else if (FluentElementInjectionSupportValidator.isWebElement(field)) {
            fieldValue = this.initFieldAsWebElement(locator);
        } else if (FluentElementInjectionSupportValidator.isListOfWebElement(field)) {
            fieldValue = this.initFieldAsListOfWebElement(locator);
        }
        return fieldValue;
    }

    private <L extends List<T>, T> ComponentAndProxy<L, List<WebElement>> initFieldAsComponentList(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        Object componentList = this.componentsManager.asComponentList(field.getType(), ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy(componentList, webElementList);
    }

    private ComponentAndProxy<Object, WebElement> initFieldAsComponent(ElementLocator locator, Field field) {
        WebElement element = LocatorProxies.createWebElement(locator);
        Object component = this.componentsManager.newComponent(field.getType(), element);
        return new ComponentAndProxy<Object, WebElement>(component, element);
    }

    private ComponentAndProxy<ComponentList<?>, List<WebElement>> initFieldAsListOfComponent(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        ComponentList<?> componentList = this.componentsManager.asComponentList(ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy(componentList, webElementList);
    }

    private ComponentAndProxy<FluentList<? extends FluentWebElement>, List<WebElement>> initFieldAsListOfFluentWebElement(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        FluentList<?> fluentList = this.componentsManager.asFluentList(ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy<FluentList<? extends FluentWebElement>, List<WebElement>>(fluentList, webElementList);
    }

    private ComponentAndProxy<WebElement, WebElement> initFieldAsWebElement(ElementLocator locator) {
        WebElement element = LocatorProxies.createWebElement(locator);
        return new ComponentAndProxy<WebElement, WebElement>(element, element);
    }

    private ComponentAndProxy<List<WebElement>, List<WebElement>> initFieldAsListOfWebElement(ElementLocator locator) {
        List<WebElement> elements = LocatorProxies.createWebElementList(locator);
        return new ComponentAndProxy<List<WebElement>, List<WebElement>>(elements, elements);
    }
}

