/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import java.util.List;
import java.util.function.Predicate;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.conditions.AbstractFluentListConditions;
import org.fluentlenium.core.domain.FluentWebElement;

public class EachElementConditions
extends AbstractFluentListConditions {
    public EachElementConditions(List<? extends FluentWebElement> elements) {
        super(elements);
    }

    @Override
    public EachElementConditions not() {
        EachElementConditions negatedConditions = new EachElementConditions(this.getElements());
        negatedConditions.setNegation(!this.isNegation());
        return negatedConditions;
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        if (this.isNegation()) {
            predicate = predicate.negate();
            defaultValue = !defaultValue;
        }
        return this.buildEachElementPredicate(predicate, defaultValue).test(null);
    }

    protected Predicate<FluentDriver> buildEachElementPredicate(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        Predicate<FluentDriver> untilPredicate = fluent -> {
            if (this.getElements().size() > 0) {
                for (FluentWebElement fluentWebElement : this.getElements()) {
                    if (predicate.test(fluentWebElement)) continue;
                    return false;
                }
                return true;
            }
            return defaultValue;
        };
        return untilPredicate;
    }
}

