/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fluentlenium.configuration.CapabilitiesFactory;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.FactoryNames;
import org.fluentlenium.configuration.IndexIgnore;
import org.openqa.selenium.Capabilities;

@IndexIgnore
public class MethodInvocationReflectionFactory
implements CapabilitiesFactory,
FactoryNames {
    private final Method method;
    private final Object instance;
    private final Object[] args;

    public MethodInvocationReflectionFactory(Method method, Object instance, Object ... args) {
        this.method = method;
        this.instance = instance;
        this.args = args;
    }

    @Override
    public Capabilities newCapabilities(ConfigurationProperties configuration) {
        try {
            return (Capabilities)this.method.invoke(this.instance, this.args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigurationException("Can't create capabilities instance", e);
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{this.method.getDeclaringClass().getName() + "." + this.method.getName(), this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName(), this.method.getName()};
    }
}

