/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class LongType
implements VariableType {
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return "long";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        return valueFields.getLongValue();
    }

    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setLongValue((Long)value);
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Long.class.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass());
    }
}

