/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.jdbc.metadata.MetadataPattern;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MetadataPatternMatcher {
    private MetadataPatternMatcher() {
    }

    public static MetadataPatternMatcher fromPattern(MetadataPattern metadataPattern) {
        return switch (metadataPattern.getConditionType()) {
            case MetadataPattern.ConditionType.NONE -> AllMatcher.INSTANCE;
            case MetadataPattern.ConditionType.SQL_EQUALS -> new EqualsMatcher(metadataPattern.getConditionValue());
            case MetadataPattern.ConditionType.SQL_STARTING_WITH -> new StartingWithMatcher(metadataPattern.getConditionValue());
            case MetadataPattern.ConditionType.SQL_LIKE -> new LikeMatcher(metadataPattern.getConditionValue());
            case MetadataPattern.ConditionType.SQL_IS_NULL -> NullMatcher.INSTANCE;
            default -> throw new AssertionError((Object)("Unexpected condition type " + String.valueOf((Object)metadataPattern.getConditionType())));
        };
    }

    public abstract boolean matches(String var1);

    public static String patternToRegex(String metadataPattern) {
        int patternLength = metadataPattern.length();
        StringBuilder patternString = new StringBuilder(patternLength + 10);
        StringBuilder subPattern = new StringBuilder();
        block4: for (int idx = 0; idx < patternLength; ++idx) {
            char charVal = metadataPattern.charAt(idx);
            switch (charVal) {
                case '%': 
                case '_': {
                    if (!subPattern.isEmpty()) {
                        patternString.append(Pattern.quote(subPattern.toString()));
                        subPattern.setLength(0);
                    }
                    patternString.append(charVal == '_' ? "." : ".*");
                    continue block4;
                }
                case '\\': {
                    if (++idx < patternLength) {
                        char nextChar = metadataPattern.charAt(idx);
                        if (!MetadataPattern.isPatternSpecialChar(nextChar)) {
                            subPattern.append('\\');
                        }
                        subPattern.append(nextChar);
                        continue block4;
                    }
                    subPattern.append('\\');
                    continue block4;
                }
                default: {
                    subPattern.append(charVal);
                }
            }
        }
        if (!subPattern.isEmpty()) {
            patternString.append(Pattern.quote(subPattern.toString()));
        }
        return patternString.toString();
    }

    private static final class AllMatcher
    extends MetadataPatternMatcher {
        private static final AllMatcher INSTANCE = new AllMatcher();

        private AllMatcher() {
        }

        @Override
        public boolean matches(String value) {
            return true;
        }
    }

    private static final class EqualsMatcher
    extends MetadataPatternMatcher {
        private final String pattern;

        private EqualsMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String value) {
            return this.pattern.equals(value);
        }
    }

    private static final class StartingWithMatcher
    extends MetadataPatternMatcher {
        private final String pattern;

        private StartingWithMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String value) {
            return value != null && value.startsWith(this.pattern);
        }
    }

    private static final class LikeMatcher
    extends MetadataPatternMatcher {
        private final Matcher regexMatcher;

        private LikeMatcher(String pattern) {
            String regexPattern = MetadataPatternMatcher.patternToRegex(pattern);
            Pattern compiledPattern = Pattern.compile(regexPattern);
            this.regexMatcher = compiledPattern.matcher("");
        }

        @Override
        public boolean matches(String value) {
            if (value == null) {
                return false;
            }
            this.regexMatcher.reset(value);
            return this.regexMatcher.matches();
        }
    }

    private static final class NullMatcher
    extends MetadataPatternMatcher {
        private static final NullMatcher INSTANCE = new NullMatcher();

        private NullMatcher() {
        }

        @Override
        public boolean matches(String value) {
            return value == null;
        }
    }
}

