/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.NameHelper;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetProcedures
extends AbstractMetadataMethod {
    private static final String PROCEDURES = "PROCEDURES";
    private static final String COLUMN_PROCEDURE_NAME = "RDB$PROCEDURE_NAME";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(9).at(0).simple(449, 63, "PROCEDURE_CAT", "PROCEDURES").addField().at(1).simple(449, 63, "PROCEDURE_SCHEM", "ROCEDURES").addField().at(2).simple(448, 63, "PROCEDURE_NAME", "PROCEDURES").addField().at(3).simple(448, 31, "FUTURE1", "PROCEDURES").addField().at(4).simple(448, 31, "FUTURE2", "PROCEDURES").addField().at(5).simple(448, 31, "FUTURE3", "PROCEDURES").addField().at(6).simple(448, Integer.MAX_VALUE, "REMARKS", "PROCEDURES").addField().at(7).simple(500, 0, "PROCEDURE_TYPE", "PROCEDURES").addField().at(8).simple(448, 131, "SPECIFIC_NAME", "PROCEDURES").addField().toRowDescriptor();

    private GetProcedures(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getProcedures(String catalog, String procedureNamePattern) throws SQLException {
        if ("".equals(procedureNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetProceduresQuery(catalog, procedureNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        String catalog = rs.getString("PROCEDURE_CAT");
        String procedureName = rs.getString("PROCEDURE_NAME");
        return valueBuilder.at(0).setString(catalog).at(2).setString(procedureName).at(6).setString(rs.getString("REMARKS")).at(7).setShort(rs.getShort("PROCEDURE_TYPE") == 0 ? 1 : 2).at(8).setString(NameHelper.toSpecificName(catalog, procedureName)).toRowValue(true);
    }

    abstract DbMetadataMediator.MetadataQuery createGetProceduresQuery(String var1, String var2);

    public static GetProcedures create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3)) {
            if (mediator.isUseCatalogAsPackage()) {
                return FB3CatalogAsPackage.createInstance(mediator);
            }
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3CatalogAsPackage
    extends GetProcedures {
        private static final String GET_PROCEDURES_FRAGMENT_3_W_PKG = "select\n  coalesce(trim(trailing from RDB$PACKAGE_NAME), '') as PROCEDURE_CAT,\n  trim(trailing from RDB$PROCEDURE_NAME) as PROCEDURE_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE\nfrom RDB$PROCEDURES";
        private static final String GET_PROCEDURES_ORDER_BY_3_W_PKG = "\norder by RDB$PACKAGE_NAME nulls first, RDB$PROCEDURE_NAME";

        private FB3CatalogAsPackage(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedures createInstance(DbMetadataMediator mediator) {
            return new FB3CatalogAsPackage(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProceduresQuery(String catalog, String procedureNamePattern) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(2);
            if (catalog != null) {
                if (catalog.isEmpty()) {
                    clauses.add(Clause.isNullClause("RDB$PACKAGE_NAME"));
                } else {
                    clauses.add(Clause.equalsClause("RDB$PACKAGE_NAME", catalog));
                }
            }
            clauses.add(new Clause(GetProcedures.COLUMN_PROCEDURE_NAME, procedureNamePattern));
            String sql = GET_PROCEDURES_FRAGMENT_3_W_PKG + (String)(Clause.anyCondition(clauses) ? "\nwhere " + Clause.conjunction(clauses) : "") + GET_PROCEDURES_ORDER_BY_3_W_PKG;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(clauses));
        }
    }

    private static final class FB3
    extends GetProcedures {
        private static final String GET_PROCEDURES_FRAGMENT_3 = "select\n  null as PROCEDURE_CAT,\n  trim(trailing from RDB$PROCEDURE_NAME) as PROCEDURE_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE\nfrom RDB$PROCEDURES\nwhere RDB$PACKAGE_NAME is null";
        private static final String GET_PROCEDURES_ORDER_BY_3 = "\norder by RDB$PACKAGE_NAME, RDB$PROCEDURE_NAME";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedures createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProceduresQuery(String catalog, String procedureNamePattern) {
            Clause procedureNameClause = new Clause(GetProcedures.COLUMN_PROCEDURE_NAME, procedureNamePattern);
            String queryText = GET_PROCEDURES_FRAGMENT_3 + procedureNameClause.getCondition("\nand ", "") + GET_PROCEDURES_ORDER_BY_3;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(procedureNameClause));
        }
    }

    private static final class FB2_5
    extends GetProcedures {
        private static final String GET_PROCEDURES_FRAGMENT_2_5 = "select\n  null as PROCEDURE_CAT,\n  RDB$PROCEDURE_NAME as PROCEDURE_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE\nfrom RDB$PROCEDURES";
        private static final String GET_PROCEDURES_ORDER_BY_2_5 = "\norder by RDB$PROCEDURE_NAME";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetProcedures createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetProceduresQuery(String catalog, String procedureNamePattern) {
            Clause procedureNameClause = new Clause(GetProcedures.COLUMN_PROCEDURE_NAME, procedureNamePattern);
            String queryText = GET_PROCEDURES_FRAGMENT_2_5 + procedureNameClause.getCondition("\nwhere ", "") + GET_PROCEDURES_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(procedureNameClause));
        }
    }
}

